/*
 * Decompiled with CFR 0.152.
 */
package com.github.chengyuxing.sql.support.executor;

import com.github.chengyuxing.common.DataRow;
import com.github.chengyuxing.sql.page.IPageable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public abstract class QueryExecutor {
    protected final String sql;
    protected Map<String, Object> args = new HashMap<String, Object>();

    public QueryExecutor(String sql) {
        this.sql = sql;
    }

    public QueryExecutor args(Map<String, Object> args) {
        if (args != null) {
            this.args = args;
        }
        return this;
    }

    public QueryExecutor arg(String key, Object value) {
        this.args.put(key, value);
        return this;
    }

    public abstract Stream<DataRow> stream();

    public abstract List<Map<String, Object>> maps();

    public abstract List<DataRow> rows();

    public abstract <T> List<T> entities(Class<T> var1);

    public abstract IPageable pageable(int var1, int var2);

    public abstract DataRow findFirstRow();

    public abstract <T> T findFirstEntity(Class<T> var1);

    public abstract Optional<DataRow> findFirst();

    public abstract boolean exists();
}

