/*
 * Decompiled with CFR 0.152.
 */
package com.github.chengyuxing.sql.transaction;

import com.github.chengyuxing.sql.datasource.AbstractTransactionSyncManager;
import com.github.chengyuxing.sql.datasource.ConnectionHolder;
import com.github.chengyuxing.sql.datasource.DataSourceUtil;
import com.github.chengyuxing.sql.exceptions.TransactionException;
import com.github.chengyuxing.sql.transaction.Definition;
import java.sql.SQLException;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Tx {
    private static final Logger log = LoggerFactory.getLogger(Tx.class);

    public static void begin(Definition definition) {
        AbstractTransactionSyncManager.initTransaction(definition);
        if (!AbstractTransactionSyncManager.isSynchronizationActive()) {
            AbstractTransactionSyncManager.initSynchronization();
        }
    }

    public static void begin() {
        Tx.begin(Definition.defaultDefinition());
    }

    public static void commit() {
        try {
            Tx.commitTransaction();
        }
        finally {
            Tx.releaseTransaction();
        }
    }

    public static void rollback() {
        try {
            Tx.rollbackTransaction();
        }
        finally {
            Tx.releaseTransaction();
        }
    }

    public static void using(Runnable runnable, Definition definition) {
        try {
            Tx.begin(definition);
            runnable.run();
            Tx.commit();
        }
        catch (Exception e) {
            Tx.rollback();
            throw new TransactionException("transaction will rollback cause:", e);
        }
    }

    public static <T> T using(Supplier<T> supplier, Definition definition) {
        try {
            Tx.begin(definition);
            T result = supplier.get();
            Tx.commit();
            return result;
        }
        catch (Exception e) {
            Tx.rollback();
            throw new TransactionException("transaction will rollback cause:", e);
        }
    }

    public static void using(Runnable runnable) {
        Tx.using(runnable, Definition.defaultDefinition());
    }

    public static <T> T using(Supplier<T> supplier) {
        return Tx.using(supplier, Definition.defaultDefinition());
    }

    private static void releaseTransaction() {
        if (AbstractTransactionSyncManager.isSynchronizationActive()) {
            AbstractTransactionSyncManager.getSynchronizations().forEach(DataSourceUtil.TransactionSynchronization::afterCompletion);
        }
        AbstractTransactionSyncManager.clear();
    }

    private static void commitTransaction() {
        log.info("commit transaction!");
        AbstractTransactionSyncManager.getSynchronizations().forEach(s -> {
            ConnectionHolder holder = s.getConnectionHolder();
            if (holder.hasConnection()) {
                try {
                    holder.getConnection().commit();
                }
                catch (SQLException e) {
                    throw new TransactionException("transaction commit failed: ", e);
                }
            }
        });
    }

    private static void rollbackTransaction() {
        log.info("rollback transaction!");
        AbstractTransactionSyncManager.getSynchronizations().forEach(s -> {
            ConnectionHolder holder = s.getConnectionHolder();
            if (holder.hasConnection()) {
                try {
                    holder.getConnection().rollback();
                }
                catch (SQLException e) {
                    throw new TransactionException("transaction rollback failed: ", e);
                }
            }
        });
    }
}

