/*
 * Decompiled with CFR 0.152.
 */
package com.github.chengyuxing.sql.utils;

import com.github.chengyuxing.common.DataRow;
import com.github.chengyuxing.common.DateTimes;
import com.github.chengyuxing.common.utils.CollectionUtil;
import com.github.chengyuxing.common.utils.ReflectUtil;
import com.github.chengyuxing.sql.types.Param;
import com.github.chengyuxing.sql.types.ParamMode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcUtil {
    private static final Logger log = LoggerFactory.getLogger(JdbcUtil.class);
    private static Class<?> pgObjClass;
    private static Method pgObjSetValue;
    private static Method pgObjSetType;

    public static Object getResultValue(ResultSet resultSet, int index) throws SQLException {
        Object obj = resultSet.getObject(index);
        String className = null;
        if (obj != null) {
            className = obj.getClass().getName();
        }
        if (obj instanceof Blob) {
            obj = JdbcUtil.getBytes((Blob)obj);
        } else if (obj instanceof Clob) {
            Clob clob = (Clob)obj;
            obj = clob.getSubString(1L, (int)clob.length());
        } else if ("org.postgresql.jdbc.PgArray".equals(className)) {
            obj = resultSet.getArray(index).getArray();
        } else if ("org.postgresql.util.PGobject".equals(className)) {
            obj = resultSet.getString(index);
        } else if ("oracle.sql.TIMESTAMP".equals(className) || "oracle.sql.TIMESTAMPTZ".equals(className)) {
            obj = resultSet.getTimestamp(index);
        } else if (className != null && className.startsWith("oracle.sql.DATE")) {
            String metaDataClassName = resultSet.getMetaData().getColumnClassName(index);
            obj = "java.sql.Timestamp".equals(metaDataClassName) || "oracle.sql.TIMESTAMP".equals(metaDataClassName) ? resultSet.getTimestamp(index) : resultSet.getDate(index);
        } else if (obj instanceof Date && "java.sql.Timestamp".equals(resultSet.getMetaData().getColumnClassName(index))) {
            obj = resultSet.getTimestamp(index);
        }
        return obj;
    }

    public static byte[] getBytes(Blob blob) throws SQLException {
        byte[] bytes = new byte[]{};
        if (blob != null) {
            try (InputStream ins = blob.getBinaryStream();){
                bytes = new byte[(int)blob.length()];
                ins.read(bytes);
            }
            catch (IOException e) {
                throw new UncheckedIOException("read blob catch an error:", e);
            }
        }
        return bytes;
    }

    public static boolean supportsBatchUpdates(Connection con) {
        try {
            DatabaseMetaData dbmd = con.getMetaData();
            if (dbmd != null) {
                if (dbmd.supportsBatchUpdates()) {
                    log.debug("JDBC driver supports batch updates");
                    return true;
                }
                log.debug("JDBC driver does not dao batch updates");
            }
        }
        catch (SQLException ex) {
            log.error("JDBC driver 'supportsBatchUpdates' method threw exception", (Throwable)ex);
        }
        return false;
    }

    public static void closeResultSet(ResultSet resultSet) throws SQLException {
        if (resultSet != null && !resultSet.isClosed()) {
            resultSet.close();
        }
    }

    public static void closeStatement(Statement statement) throws SQLException {
        if (statement != null && !statement.isClosed()) {
            statement.close();
        }
    }

    public static String[] createNames(ResultSet resultSet, String executedSql) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        int columnCount = metaData.getColumnCount();
        String[] names = new String[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            String columnName = metaData.getColumnName(i + 1);
            names[i] = executedSql.contains("\"" + columnName + "\"") ? columnName : columnName.toLowerCase();
        }
        return names;
    }

    public static DataRow createDataRow(String[] names, ResultSet resultSet) throws SQLException {
        DataRow row = new DataRow(names.length);
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if (name.equals("?column?")) {
                name = "column" + i;
            }
            row.put((Object)name, JdbcUtil.getResultValue(resultSet, i + 1));
        }
        return row;
    }

    public static List<DataRow> createDataRows(ResultSet resultSet, String executedSql, long fetchSize) throws SQLException {
        if (resultSet == null) {
            return Collections.emptyList();
        }
        ArrayList<DataRow> list = new ArrayList<DataRow>();
        String[] names = null;
        for (long size = fetchSize; resultSet.next() && size != 0L; --size) {
            if (names == null) {
                names = JdbcUtil.createNames(resultSet, executedSql);
            }
            list.add(JdbcUtil.createDataRow(names, resultSet));
        }
        return list;
    }

    public static Object createPgObject(String type, String value) {
        try {
            if (pgObjClass == null) {
                pgObjClass = Class.forName("org.postgresql.util.PGobject");
            }
            if (pgObjSetType == null) {
                pgObjSetType = pgObjClass.getDeclaredMethod("setType", String.class);
            }
            if (pgObjSetValue == null) {
                pgObjSetValue = pgObjClass.getDeclaredMethod("setValue", String.class);
            }
            Object pgObj = pgObjClass.newInstance();
            pgObjSetType.invoke(pgObj, type);
            pgObjSetValue.invoke(pgObj, value);
            return pgObj;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("create postgresql object type error:", e);
        }
    }

    public static void setSpecialStatementValue(PreparedStatement statement, int index, Object value) throws SQLException {
        int pType;
        String pTypeName;
        String pClass;
        try {
            ParameterMetaData pmd = statement.getParameterMetaData();
            pClass = pmd.getParameterClassName(index);
            pTypeName = pmd.getParameterTypeName(index);
            pType = pmd.getParameterType(index);
        }
        catch (SQLException e) {
            log.warn("maybe jdbc driver not support the check parameter type, set 'checkParameterType' false to disabled the check: ", (Throwable)e);
            log.warn("auto switch normal mode to set value...");
            JdbcUtil.setStatementValue(statement, index, value);
            return;
        }
        if (null == value) {
            statement.setNull(index, pType);
        } else if (pTypeName.equals("json") || pTypeName.equals("jsonb")) {
            log.warn("you try to set a value into json(b) type field, auto wrap for json(b) type!");
            if (value instanceof String) {
                statement.setObject(index, JdbcUtil.createPgObject(pTypeName, value.toString()));
            } else {
                statement.setObject(index, JdbcUtil.createPgObject(pTypeName, ReflectUtil.obj2Json((Object)value)));
            }
        } else if (pClass.equals("java.lang.String") && !(value instanceof String)) {
            if (value instanceof Map || value instanceof Collection) {
                log.warn("you try to set a Map or Collection data into database string type field, auto convert to json string!");
                statement.setObject(index, ReflectUtil.obj2Json((Object)value));
            } else if (value instanceof UUID) {
                statement.setObject(index, value.toString().replace("-", ""));
            } else if (value.getClass().getTypeName().startsWith("java.")) {
                statement.setObject(index, value.toString());
            } else {
                log.warn("you try to set an unknown class instance(maybe your java bean) data into string type field, auto convert to json string!");
                statement.setObject(index, ReflectUtil.obj2Json((Object)value));
            }
        } else if (pClass.equals("java.sql.Array") && value instanceof Collection) {
            statement.setObject(index, ((Collection)value).toArray());
        } else if (pClass.equals("java.sql.Date") && value instanceof String) {
            statement.setObject(index, new Date(DateTimes.toEpochMilli((String)((String)value))));
        } else if (pClass.equals("java.sql.Time") && value instanceof String) {
            statement.setObject(index, new Time(DateTimes.toEpochMilli((String)((String)value))));
        } else if (pClass.equals("java.sql.Timestamp") && value instanceof String) {
            statement.setObject(index, new Timestamp(DateTimes.toEpochMilli((String)((String)value))));
        } else {
            JdbcUtil.setStatementValue(statement, index, value);
        }
    }

    public static void setStatementValue(PreparedStatement statement, int index, Object value) throws SQLException {
        if (null == value) {
            statement.setNull(index, 0);
        } else if (value instanceof java.util.Date) {
            statement.setObject(index, new Timestamp(((java.util.Date)value).getTime()));
        } else if (value instanceof LocalDateTime) {
            statement.setObject(index, new Timestamp(((LocalDateTime)value).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli()));
        } else if (value instanceof LocalDate) {
            statement.setObject(index, new Date(((LocalDate)value).atStartOfDay(ZoneOffset.systemDefault()).toInstant().toEpochMilli()));
        } else if (value instanceof LocalTime) {
            statement.setObject(index, new Time(((LocalTime)value).atDate(LocalDate.now()).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli()));
        } else if (value instanceof Instant) {
            statement.setObject(index, new Timestamp(((Instant)value).toEpochMilli()));
        } else if (value instanceof UUID) {
            statement.setObject(index, value.toString().replace("-", ""));
        } else if (value instanceof Map || value instanceof Collection) {
            log.warn("you try to set a Map or Collection data, auto convert to json string!");
            statement.setObject(index, ReflectUtil.obj2Json((Object)value));
        } else if (!value.getClass().getTypeName().startsWith("java.")) {
            log.warn("you try to set an unknown class instance(maybe your java bean) data, auto convert to json string!");
            statement.setObject(index, ReflectUtil.obj2Json((Object)value));
        } else if (value instanceof InputStream) {
            statement.setBinaryStream(index, (InputStream)value);
        } else if (value instanceof Path) {
            try {
                statement.setBinaryStream(index, Files.newInputStream((Path)value, new OpenOption[0]));
            }
            catch (IOException e) {
                throw new SQLException("set binary value failed: ", e);
            }
        } else if (value instanceof File) {
            try {
                statement.setBinaryStream(index, new FileInputStream((File)value));
            }
            catch (FileNotFoundException e) {
                throw new SQLException("set binary value failed: ", e);
            }
        } else {
            statement.setObject(index, value);
        }
    }

    public static void setSqlTypedArgs(PreparedStatement statement, boolean checkParameterType, Map<String, ?> args, List<String> names) throws SQLException {
        if (args != null && !args.isEmpty()) {
            if (checkParameterType) {
                for (int i = 0; i < names.size(); ++i) {
                    int index = i + 1;
                    String name = names.get(i);
                    if (args.containsKey(name)) {
                        JdbcUtil.setSpecialStatementValue(statement, index, args.get(name));
                        continue;
                    }
                    if (!CollectionUtil.containsKeyIgnoreCase(args, (String)name)) continue;
                    log.warn("cannot find name: '{}' in args: {}, auto get value by '{}' ignore case, maybe you should check your sql's named parameter and args.", new Object[]{name, args, name});
                    JdbcUtil.setSpecialStatementValue(statement, index, CollectionUtil.getValueIgnoreCase(args, (String)name));
                }
            } else {
                JdbcUtil.setSqlPoolArgs(statement, args, names);
            }
        }
    }

    public static void setSqlPoolArgs(PreparedStatement statement, Map<String, ?> args, List<String> names) throws SQLException {
        for (int i = 0; i < names.size(); ++i) {
            int index = i + 1;
            String name = names.get(i);
            if (args.containsKey(name)) {
                JdbcUtil.setStatementValue(statement, index, args.get(name));
                continue;
            }
            if (!CollectionUtil.containsKeyIgnoreCase(args, (String)name)) continue;
            log.warn("cannot find name: '{}' in args: {}, auto get value by '{}' ignore case, maybe you should check your sql's named parameter and args.", new Object[]{name, args, name});
            JdbcUtil.setStatementValue(statement, index, CollectionUtil.getValueIgnoreCase(args, (String)name));
        }
    }

    public static void setStoreArgs(CallableStatement statement, Map<String, Param> args, List<String> names) throws SQLException {
        if (args != null && !args.isEmpty()) {
            Param param;
            String name;
            int index;
            int i;
            for (i = 0; i < names.size(); ++i) {
                index = i + 1;
                name = names.get(i);
                if (!args.containsKey(name) && !CollectionUtil.containsKeyIgnoreCase(args, (String)name)) continue;
                Param param2 = param = args.containsKey(name) ? args.get(name) : (Param)CollectionUtil.getValueIgnoreCase(args, (String)name);
                if (param == null || param.getParamMode() != ParamMode.OUT && param.getParamMode() != ParamMode.IN_OUT) continue;
                statement.registerOutParameter(index, param.getType().getTypeNumber());
            }
            for (i = 0; i < names.size(); ++i) {
                index = i + 1;
                name = names.get(i);
                if (!args.containsKey(name) && !CollectionUtil.containsKeyIgnoreCase(args, (String)name)) continue;
                Param param3 = param = args.containsKey(name) ? args.get(name) : (Param)CollectionUtil.getValueIgnoreCase(args, (String)name);
                if (param == null || param.getParamMode() != ParamMode.IN && param.getParamMode() != ParamMode.IN_OUT) continue;
                JdbcUtil.setStatementValue(statement, index, param.getValue());
            }
        }
    }
}

