/*
 * Decompiled with CFR 0.152.
 */
package com.github.chengyuxing.sql.utils;

import com.github.chengyuxing.common.tuple.Pair;
import com.github.chengyuxing.common.utils.CollectionUtil;
import com.github.chengyuxing.common.utils.ObjectUtil;
import com.github.chengyuxing.common.utils.StringUtil;
import com.github.chengyuxing.sql.utils.SqlUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlTranslator {
    private static final Logger log = LoggerFactory.getLogger(SqlTranslator.class);
    private String namedParamPrefix = ":";
    private static final char SPECIAL_CHAR = '\u0c32';
    Pattern PARAM_PATTERN = Pattern.compile("(^:|[^:]:)(?<name>[a-zA-Z_][\\w_]*)", 8);
    Pattern STR_TEMP_PATTERN = Pattern.compile("\\$\\{\\s*(?<key>:?[\\w._-]+)\\s*}");

    public SqlTranslator(char _namedParamPrefix) {
        String cs;
        if (_namedParamPrefix == ' ') {
            throw new IllegalArgumentException("prefix char cannot be empty.");
        }
        if (_namedParamPrefix == ':') {
            return;
        }
        this.namedParamPrefix = cs = String.valueOf(_namedParamPrefix);
        String regC = cs.replace(cs, "\\" + cs);
        this.PARAM_PATTERN = Pattern.compile("(^" + regC + "|[^" + regC + "]" + regC + ")(?<name>[a-zA-Z_][\\w_]*)", 8);
        this.STR_TEMP_PATTERN = Pattern.compile("\\$\\{\\s*(?<key>" + regC + "?[\\w._-]+)\\s*}");
    }

    public Pattern getPARAM_PATTERN() {
        return this.PARAM_PATTERN;
    }

    public Pattern getSTR_TEMP_PATTERN() {
        return this.STR_TEMP_PATTERN;
    }

    public String getNamedParamPrefix() {
        return this.namedParamPrefix;
    }

    public Pair<String, List<String>> generateSql(String sql, Map<String, ?> args, boolean prepare) {
        Map placeholderMapper;
        String name;
        String fullSql;
        HashMap<Object, Object> argx = new HashMap();
        if (args != null && !args.isEmpty()) {
            argx = new HashMap(args);
        }
        if (!(fullSql = this.formatSql(sql, argx)).contains(this.namedParamPrefix)) {
            return Pair.of((Object)fullSql, Collections.emptyList());
        }
        Pair<String, Map<String, String>> noneStrSqlAndHolder = SqlUtil.replaceSqlSubstr(fullSql);
        String noneStrSql = (String)noneStrSqlAndHolder.getItem1();
        Matcher matcher = this.PARAM_PATTERN.matcher(noneStrSql);
        ArrayList<String> names = new ArrayList<String>();
        if (prepare) {
            while (matcher.find()) {
                name = matcher.group("name");
                names.add(name);
                noneStrSql = StringUtil.replaceFirst((String)noneStrSql, (String)(this.namedParamPrefix + name), (String)"?");
            }
        } else {
            while (matcher.find()) {
                String value;
                name = matcher.group("name");
                names.add(name);
                if (argx.containsKey(name)) {
                    value = SqlUtil.quoteFormatValueIfNecessary(argx.get(name));
                    noneStrSql = StringUtil.replaceFirst((String)noneStrSql, (String)(this.namedParamPrefix + name), (String)value);
                    continue;
                }
                if (!CollectionUtil.containsKeyIgnoreCase(argx, (String)name)) continue;
                log.warn("cannot find name: '{}' in args: {}, auto get value by '{}' ignore case, maybe you should check your sql's named parameter and args.", new Object[]{name, args, name});
                value = SqlUtil.quoteFormatValueIfNecessary(CollectionUtil.getValueIgnoreCase(argx, (String)name));
                noneStrSql = StringUtil.replaceFirstIgnoreCase((String)noneStrSql, (String)(this.namedParamPrefix + name), (String)value);
            }
        }
        if (!(placeholderMapper = (Map)noneStrSqlAndHolder.getItem2()).isEmpty()) {
            for (Map.Entry e : placeholderMapper.entrySet()) {
                noneStrSql = noneStrSql.replace((CharSequence)e.getKey(), (CharSequence)e.getValue());
            }
        }
        return Pair.of((Object)noneStrSql, names);
    }

    public Pair<String, List<String>> getPreparedSql(String sql, Map<String, ?> args) {
        return this.generateSql(sql, args, true);
    }

    public String formatSql(String str, Map<String, ?> args) {
        if (args == null || args.isEmpty()) {
            return str;
        }
        String copyStr = str;
        Matcher m = this.STR_TEMP_PATTERN.matcher(copyStr);
        if (m.find()) {
            String tempKey = m.group(0);
            String key = m.group("key");
            boolean quote = key.startsWith(this.namedParamPrefix);
            if (quote) {
                key = key.substring(1);
            }
            boolean isKeyPath = key.contains(".") && !args.containsKey(key);
            String tk = key;
            if (isKeyPath) {
                tk = key.substring(0, key.indexOf("."));
            }
            if (!args.containsKey(tk)) {
                copyStr = copyStr.replace(tempKey, '\u0c32' + tempKey.substring(1));
            }
            try {
                String subStr = isKeyPath ? SqlUtil.deconstructArrayIfNecessary(ObjectUtil.getDeepNestValue(args, (String)("/" + key.replace(".", "/"))), quote) : SqlUtil.deconstructArrayIfNecessary(args.get(key), quote);
                copyStr = copyStr.replace(tempKey, subStr);
                return this.formatSql(copyStr, args);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        if (copyStr.lastIndexOf(3122) != -1) {
            copyStr = copyStr.replace('\u0c32', '$');
        }
        return copyStr;
    }

    public Set<String> filterKeys(Map<String, ?> row, List<String> fields) {
        if (fields == null || fields.isEmpty()) {
            return row.keySet();
        }
        String[] fieldArr = fields.toArray(new String[0]);
        HashSet<String> set = new HashSet<String>();
        for (String k : row.keySet()) {
            if (!StringUtil.equalsAnyIgnoreCase((String)k, (String[])fieldArr) || CollectionUtil.containsIgnoreCase(set, (String)k)) continue;
            set.add(k);
        }
        return set;
    }

    public String generateInsert(String tableName, Map<String, ?> row, List<String> fields) {
        Set<String> keys = this.filterKeys(row, fields);
        if (keys.isEmpty()) {
            throw new IllegalArgumentException("empty field set, generate insert sql error.");
        }
        StringJoiner f = new StringJoiner(", ");
        StringJoiner v = new StringJoiner(", ");
        for (String key : keys) {
            if (row.containsKey(key)) {
                f.add(key);
                v.add(SqlUtil.quoteFormatValueIfNecessary(row.get(key)));
                continue;
            }
            if (!CollectionUtil.containsKeyIgnoreCase(row, (String)key)) continue;
            log.warn("cannot find name: '{}' in args: {}, auto get value by '{}' ignore case, maybe you should check your sql's named parameter and args.", new Object[]{key, row, key});
            f.add(key);
            v.add(SqlUtil.quoteFormatValueIfNecessary(CollectionUtil.getValueIgnoreCase(row, (String)key)));
        }
        return "insert into " + tableName + "(" + f + ") \nvalues (" + v + ")";
    }

    public String generateNamedParamInsert(String tableName, Map<String, ?> row, List<String> fields) {
        Set<String> keys = this.filterKeys(row, fields);
        if (keys.isEmpty()) {
            throw new IllegalArgumentException("empty field set, generate insert sql error.");
        }
        StringJoiner f = new StringJoiner(", ");
        StringJoiner h = new StringJoiner(", ");
        for (String key : keys) {
            if (!row.containsKey(key) && !CollectionUtil.containsKeyIgnoreCase(row, (String)key)) continue;
            f.add(key);
            h.add(this.namedParamPrefix + key);
        }
        return "insert into " + tableName + "(" + f + ") \nvalues (" + h + ")";
    }

    public String generateUpdate(String tableName, Map<String, ?> data, List<String> fields) {
        return this.generateUpdate(tableName, data, fields, false);
    }

    public String generateUpdate(String tableName, Map<String, ?> data) {
        return this.generateUpdate(tableName, data, Collections.emptyList());
    }

    public String generateNamedParamUpdate(String tableName, Map<String, ?> data, List<String> fields) {
        return this.generateUpdate(tableName, data, fields, true);
    }

    public String generateNamedParamUpdate(String tableName, Map<String, ?> data) {
        return this.generateNamedParamUpdate(tableName, data, Collections.emptyList());
    }

    public String generateUpdate(String tableName, Map<String, ?> data, List<String> fields, boolean isNamedParam) {
        if (data.isEmpty()) {
            throw new IllegalArgumentException("empty field set, generate update sql error.");
        }
        Set<String> keys = this.filterKeys(data, fields);
        if (keys.isEmpty()) {
            throw new IllegalArgumentException("empty field set, generate update sql error.");
        }
        StringJoiner sb = new StringJoiner(",\n\t");
        if (isNamedParam) {
            for (String key : keys) {
                if (!data.containsKey(key) && !CollectionUtil.containsKeyIgnoreCase(data, (String)key)) continue;
                sb.add(key + " = " + this.namedParamPrefix + key);
            }
        } else {
            for (String key : keys) {
                String v;
                if (data.containsKey(key)) {
                    v = SqlUtil.quoteFormatValueIfNecessary(data.get(key));
                    sb.add(key + " = " + v);
                    continue;
                }
                if (!CollectionUtil.containsKeyIgnoreCase(data, (String)key)) continue;
                log.warn("cannot find name: '{}' in args: {}, auto get value by '{}' ignore case, maybe you should check your sql's named parameter and args.", new Object[]{key, data, key});
                v = SqlUtil.quoteFormatValueIfNecessary(CollectionUtil.getValueIgnoreCase(data, (String)key));
                sb.add(key + " = " + v);
            }
        }
        return "update " + tableName + " \nset " + sb;
    }

    public String generateCountQuery(String recordQuery) {
        if (StringUtil.startsWithIgnoreCase((String)recordQuery.trim(), (String)"with")) {
            // empty if block
        }
        return "select count(*) from (" + recordQuery + ") r_data";
    }
}

