/*
 * Decompiled with CFR 0.152.
 */
package com.github.chengyuxing.sql.utils;

import com.github.chengyuxing.common.DateTimes;
import com.github.chengyuxing.common.console.Color;
import com.github.chengyuxing.common.console.Printer;
import com.github.chengyuxing.common.tuple.Pair;
import com.github.chengyuxing.common.utils.ReflectUtil;
import com.github.chengyuxing.common.utils.StringUtil;
import com.github.chengyuxing.sql.Keywords;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SqlUtil {
    public static final Pattern SUB_STR_PATTERN = Pattern.compile("'[^']*'", 8);

    public static String quote(String value) {
        return "'" + value + "'";
    }

    public static String safeQuote(String value) {
        if (value.contains("'")) {
            value = value.replace("'", "''");
        }
        return SqlUtil.quote(value);
    }

    public static String quoteFormatValueIfNecessary(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof String) {
            return SqlUtil.safeQuote((String)obj);
        }
        if (ReflectUtil.isBasicType((Object)obj)) {
            return obj.toString();
        }
        Class<?> clazz = obj.getClass();
        if (Date.class.isAssignableFrom(clazz)) {
            String dtStr = DateTimes.of((Temporal)((Date)obj).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime()).toString("yyyy-MM-dd HH:mm:ss");
            return "to_timestamp(" + SqlUtil.quote(dtStr) + "," + SqlUtil.quote("yyyy-mm-dd hh24:mi:ss") + ")";
        }
        if (clazz == LocalDateTime.class) {
            String dtStr = DateTimes.of((Temporal)((LocalDateTime)obj)).toString("yyyy-MM-dd HH:mm:ss");
            return "to_timestamp(" + SqlUtil.quote(dtStr) + "," + SqlUtil.quote("yyyy-mm-dd hh24:mi:ss") + ")";
        }
        if (clazz == LocalDate.class) {
            String dtStr = DateTimes.of((Temporal)((LocalDate)obj)).toString("yyyy-MM-dd");
            return "to_date(" + SqlUtil.quote(dtStr) + "," + SqlUtil.quote("yyyy-mm-dd") + ")";
        }
        if (clazz == LocalTime.class) {
            String dtStr = DateTimes.of((Temporal)((LocalTime)obj).atDate(LocalDate.now()).atZone(ZoneId.systemDefault()).toInstant()).toString("yyyy-MM-dd HH:mm:ss");
            return "to_timestamp(" + SqlUtil.quote(dtStr) + "," + SqlUtil.quote("yyyy-mm-dd hh24:mi:ss") + ")";
        }
        if (clazz == byte[].class) {
            return SqlUtil.quote("blob:" + StringUtil.getSize((byte[])((byte[])obj)));
        }
        if (Object[].class.isAssignableFrom(clazz)) {
            Object[] objArr = (Object[])obj;
            CharSequence[] res = new String[objArr.length];
            for (int i = 0; i < res.length; ++i) {
                Object o = objArr[i];
                if (o == null) continue;
                res[i] = o instanceof String ? SqlUtil.safeQuote(o.toString()) : o.toString();
            }
            return SqlUtil.quote("{" + String.join((CharSequence)",", res) + "}");
        }
        if (Map.class.isAssignableFrom(clazz) || Collection.class.isAssignableFrom(clazz) || !clazz.getTypeName().startsWith("java.")) {
            String value = ReflectUtil.obj2Json((Object)obj);
            if (value != null) {
                return SqlUtil.safeQuote(value);
            }
            return "null";
        }
        return SqlUtil.safeQuote(obj.toString());
    }

    public static Pair<String, Map<String, String>> replaceSqlSubstr(String sql) {
        if (!sql.contains("'")) {
            return Pair.of((Object)sql, Collections.emptyMap());
        }
        String noneStrSql = sql;
        HashMap<String, String> mapper = new HashMap<String, String>();
        Matcher m = SUB_STR_PATTERN.matcher(sql);
        while (m.find()) {
            String str = m.group();
            String placeHolder = "\u02de" + str.hashCode() + "\u02de";
            noneStrSql = noneStrSql.replace(str, placeHolder);
            mapper.put(placeHolder, str);
        }
        return Pair.of((Object)noneStrSql, mapper);
    }

    public static String trimEnd(String sql) {
        String tSql = sql.replaceAll("([\\s;]*)$", "");
        if (StringUtil.startsWithIgnoreCase((String)tSql, (String)"begin") && StringUtil.endsWithIgnoreCase((String)tSql, (String)"end")) {
            tSql = tSql + ";";
        }
        return tSql;
    }

    public static String cleanLineAnnotation(String line) {
        return line.substring(0, line.indexOf("--"));
    }

    public static String removeAnnotationBlock(String sql) {
        Pair<String, Map<String, String>> noneStrSqlAndHolder = SqlUtil.replaceSqlSubstr(sql);
        String noneStrSql = (String)noneStrSqlAndHolder.getItem1();
        Map placeholderMapper = (Map)noneStrSqlAndHolder.getItem2();
        char[] chars = noneStrSql.toCharArray();
        ArrayList<Character> characters = new ArrayList<Character>();
        int count = 0;
        for (int i = 0; i < chars.length; ++i) {
            int prev = i;
            int next = i;
            if (i > 0) {
                prev = i - 1;
            }
            if (i < chars.length - 1) {
                next = i + 1;
            }
            if (chars[i] == '/' && chars[next] == '*') {
                ++count;
                continue;
            }
            if (chars[i] == '*' && chars[next] == '/') {
                --count;
                continue;
            }
            if (count != 0) continue;
            if (chars[prev] == '*') {
                if (chars[i] == '/') continue;
                characters.add(Character.valueOf(chars[i]));
                continue;
            }
            characters.add(Character.valueOf(chars[i]));
        }
        StringBuilder sb = new StringBuilder();
        for (Character c : characters) {
            sb.append(c);
        }
        String noneBSql = sb.toString().replaceAll("\n\\s*\n", "\n");
        for (String key : placeholderMapper.keySet()) {
            noneBSql = noneBSql.replace(key, (CharSequence)placeholderMapper.get(key));
        }
        return noneBSql;
    }

    public static List<String> getAnnotationBlock(String sql) {
        Pair<String, Map<String, String>> noneStrSqlAndHolder = SqlUtil.replaceSqlSubstr(sql);
        String noneStrSql = (String)noneStrSqlAndHolder.getItem1();
        Map placeholderMapper = (Map)noneStrSqlAndHolder.getItem2();
        char[] chars = noneStrSql.toCharArray();
        StringBuilder annotations = new StringBuilder();
        int count = 0;
        for (int i = 0; i < chars.length; ++i) {
            int prev = i;
            int next = i;
            if (i > 0) {
                prev = i - 1;
            }
            if (i < chars.length - 1) {
                next = i + 1;
            }
            if (chars[i] == '/' && chars[next] == '*') {
                ++count;
                annotations.append("/");
                continue;
            }
            if (chars[i] == '*' && chars[next] == '/') {
                --count;
                annotations.append("*");
                continue;
            }
            if (count == 0) {
                if (chars[prev] != '*' || chars[i] != '/') continue;
                annotations.append("/").append("\u02ac");
                continue;
            }
            annotations.append(chars[i]);
        }
        String annotationStr = annotations.toString();
        for (String key : placeholderMapper.keySet()) {
            if (!annotationStr.contains(key)) continue;
            annotationStr = annotationStr.replace(key, (CharSequence)placeholderMapper.get(key));
        }
        return Arrays.asList(annotationStr.split("\u02ac"));
    }

    public static String deconstructArrayIfNecessary(Object value, boolean quote) {
        Object[] values = value instanceof Object[] ? (Object[])value : (value instanceof Collection ? ((Collection)value).toArray() : new Object[]{value});
        StringJoiner sb = new StringJoiner(", ");
        if (quote) {
            for (Object v : values) {
                sb.add(SqlUtil.quoteFormatValueIfNecessary(v));
            }
        } else {
            for (Object v : values) {
                if (v == null) continue;
                sb.add(v.toString());
            }
        }
        return sb.toString();
    }

    public static String repairSyntaxError(String sql) {
        Pattern p;
        Matcher m;
        if (StringUtil.startsWithIgnoreCase((String)sql.trim(), (String)"update") && (m = (p = Pattern.compile(",\\s*where", 2)).matcher(sql)).find()) {
            sql = sql.substring(0, m.start()).concat(sql.substring(m.start() + 1));
        }
        if ((m = (p = Pattern.compile("where\\s+(and|or)\\s+", 2)).matcher(sql)).find()) {
            return sql.substring(0, m.start() + 6).concat(sql.substring(m.end()));
        }
        p = Pattern.compile("where\\s+(order by|limit|group by|union|\\))\\s+", 2);
        m = p.matcher(sql);
        if (m.find()) {
            return sql.substring(0, m.start()).concat(sql.substring(m.start() + 6));
        }
        p = Pattern.compile("where\\s*$", 2);
        m = p.matcher(sql);
        if (m.find()) {
            return sql.substring(0, m.start());
        }
        return sql;
    }

    public static String highlightSql(String sql) {
        try {
            Pair<String, Map<String, String>> r = SqlUtil.replaceSqlSubstr(sql);
            String rSql = (String)r.getItem1();
            Pair x = StringUtil.regexSplit((String)rSql, (String)"(?<sp>[\\s,\\[\\]()::;])", (String)"sp");
            List maybeKeywords = (List)x.getItem1();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < maybeKeywords.size(); ++i) {
                String key = (String)maybeKeywords.get(i);
                if (!key.trim().equals("")) {
                    if (StringUtil.equalsAnyIgnoreCase((String)key, (String[])Keywords.STANDARD) || StringUtil.equalsAnyIgnoreCase((String)key, (String[])Keywords.POSTGRESQL)) {
                        maybeKeywords.set(i, Printer.colorful((String)key, (Color)Color.DARK_PURPLE));
                    } else if (StringUtil.containsAnyIgnoreCase((String)key, (String[])Keywords.FUNCTIONS)) {
                        if (rSql.contains(key + "(")) {
                            maybeKeywords.set(i, Printer.colorful((String)key, (Color)Color.YELLOW));
                        }
                    } else if (StringUtil.isNumeric((Object)key)) {
                        maybeKeywords.set(i, Printer.colorful((String)key, (Color)Color.DARK_CYAN));
                    } else if (key.equals("$$")) {
                        maybeKeywords.set(i, Printer.colorful((String)key, (Color)Color.DARK_GREEN));
                    } else if (key.contains("*") && !key.contains("/*") && !key.contains("*/")) {
                        maybeKeywords.set(i, key.replace("*", Printer.colorful((String)"*", (Color)Color.YELLOW)));
                    }
                }
                sb.append((String)maybeKeywords.get(i));
                if (i >= maybeKeywords.size() - 1) continue;
                sb.append((String)((List)x.getItem2()).get(i));
            }
            String colorfulSql = sb.toString();
            Map subStr = (Map)r.getItem2();
            for (String key : subStr.keySet()) {
                colorfulSql = colorfulSql.replace(key, Printer.colorful((String)((String)subStr.get(key)), (Color)Color.DARK_GREEN));
            }
            CharSequence[] sqlLine = colorfulSql.split("\n");
            for (int i = 0; i < sqlLine.length; ++i) {
                String line = sqlLine[i];
                if (line.trim().startsWith("--")) {
                    sqlLine[i] = Printer.colorful((String)line.replaceAll("\u001b\\[\\d{2}m|\u001b\\[0m", ""), (Color)Color.SILVER);
                    continue;
                }
                if (!line.contains("--")) continue;
                int idx = line.indexOf("--");
                sqlLine[i] = line.substring(0, idx) + Printer.colorful((String)line.substring(idx).replaceAll("\u001b\\[\\d{2}m|\u001b\\[0m", ""), (Color)Color.SILVER);
            }
            colorfulSql = String.join((CharSequence)"\n", sqlLine);
            if (colorfulSql.contains("/*") && colorfulSql.contains("*/")) {
                List<String> annotations = SqlUtil.getAnnotationBlock(colorfulSql);
                for (String annotation : annotations) {
                    colorfulSql = colorfulSql.replace(annotation, Printer.colorful((String)annotation.replaceAll("\u001b\\[\\d{2}m|\u001b\\[0m", ""), (Color)Color.SILVER));
                }
            }
            return colorfulSql;
        }
        catch (Exception e) {
            e.printStackTrace();
            return sql;
        }
    }

    public static String buildPrintSql(String sql, boolean isHighlight) {
        if (isHighlight) {
            return SqlUtil.highlightSql(sql);
        }
        return sql;
    }
}

