/*
 * Decompiled with CFR 0.152.
 */
package httpserver.core;

import httpserver.core.FormData;
import httpserver.core.HttpServerExchange;
import httpserver.error.InvalidInput;

public final class InputParser
extends Enum<InputParser> {
    private static final /* synthetic */ InputParser[] $VALUES;

    public static InputParser[] values() {
        return (InputParser[])$VALUES.clone();
    }

    public static InputParser valueOf(String name) {
        return Enum.valueOf(InputParser.class, name);
    }

    public static String getMandatoryString(FormData formData, String parameter) throws InvalidInput {
        String value = formData.get(parameter);
        if (value == null) {
            throw new InvalidInput(String.format("Missing parameter '%s'", parameter));
        }
        return value;
    }

    public static long getMandatoryLong(FormData formData, String parameter) throws InvalidInput {
        try {
            return Long.parseLong(InputParser.getMandatoryString(formData, parameter));
        }
        catch (NumberFormatException e) {
            throw new InvalidInput(String.format("Parameter '%s' must contain a long", parameter));
        }
    }

    public static long getMandatoryLong(HttpServerExchange exchange, String parameter) throws InvalidInput {
        String param = exchange.getQueryParameter(parameter);
        if (param == null || param.isEmpty()) {
            throw new InvalidInput(String.format("Missing parameter '%s'", parameter));
        }
        try {
            return Long.parseLong(param);
        }
        catch (NumberFormatException e) {
            throw new InvalidInput(String.format("Parameter '%s' must contain a long", parameter));
        }
    }

    private static /* synthetic */ InputParser[] $values() {
        return new InputParser[0];
    }

    static {
        $VALUES = InputParser.$values();
    }
}

