/*
 * Decompiled with CFR 0.152.
 */
package httpserver.error;

import httpserver.core.ContentType;
import httpserver.core.HttpServerExchange;
import httpserver.util.Encoding;
import java.nio.charset.StandardCharsets;

public interface HttpError {
    public static final String RESPONSE_INTERNAL_ERROR = "{\"success\":false,\"code\":500,\"message\":\"Internal Error\"}";
    public static final String ERROR_MESSAGE = "{\"success\":false,\"code\":%d,\"errorCode\":%d,\"message\":\"%s\"}";

    public void processExchange(HttpServerExchange var1);

    public static void respondInternalError(HttpServerExchange exchange) {
        if (!exchange.isResponseSent()) {
            exchange.setStatusCode(500);
            exchange.setResponseHeader("Content-Type", ContentType.application_json.toString());
            exchange.send(RESPONSE_INTERNAL_ERROR, StandardCharsets.UTF_8);
        }
    }

    public static void respondError(HttpServerExchange exchange, int statusCode, int errorCode, String message) {
        if (!exchange.isResponseSent()) {
            exchange.setStatusCode(statusCode);
            exchange.setResponseHeader("Content-Type", ContentType.application_json.toString());
            exchange.send(HttpError.errorMessage(statusCode, errorCode, message), StandardCharsets.UTF_8);
        }
    }

    private static String errorMessage(int statusCode, int errorCode, String message) {
        return String.format(ERROR_MESSAGE, statusCode, errorCode, Encoding.escapeJson(message));
    }
}

