/*
 * Decompiled with CFR 0.152.
 */
package httpserver.error;

import httpserver.core.HttpServerExchange;
import httpserver.error.HttpError;

public final class InvalidInput
extends Exception
implements HttpError {
    private final int errorCode;

    public InvalidInput(String message) {
        this(400, message, null);
    }

    public InvalidInput(String message, Throwable cause) {
        this(400, message, cause);
    }

    public InvalidInput(int errorCode, String message) {
        this(errorCode, message, null);
    }

    public InvalidInput(int errorCode, String message, Throwable cause) {
        super(message, cause);
        this.errorCode = errorCode;
    }

    @Override
    public void processExchange(HttpServerExchange exchange) {
        HttpError.respondError(exchange, 400, this.errorCode, this.getMessage());
    }
}

