/*
 * Decompiled with CFR 0.152.
 */
package httpserver.handlers;

import httpserver.HttpHandler;
import httpserver.core.HttpServerExchange;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;

public class ServerSentEvents
implements HttpHandler {
    private final Timer timer = new Timer();
    private final List<PrintWriter> connections = new ArrayList<PrintWriter>();

    public ServerSentEvents() {
        this(TimeUnit.MINUTES.toMillis(1L));
    }

    public ServerSentEvents(long l) {
        if (l < 1000L) {
            throw new IllegalArgumentException("Set a reasonable time between keep-alive messages; x >= 1000");
        }
        this.timer.scheduleAtFixedRate(ServerSentEvents.newKeepAliveTask(this.connections), l, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
        httpServerExchange.setStatusCode(200);
        httpServerExchange.setResponseHeader("Cache-Control", "no-cache");
        httpServerExchange.setResponseHeader("Connection", "keep-alive");
        httpServerExchange.setResponseHeader("Content-Type", "text/event-stream");
        httpServerExchange.setNoContentLength();
        httpServerExchange.sendResponse();
        List<PrintWriter> list = this.connections;
        synchronized (list) {
            this.connections.add(new PrintWriter(httpServerExchange.getOutputStream()));
        }
    }

    public void sendMessage(String string) {
        this.sendMessage(null, string);
    }

    public void sendMessage(String string, String string2) {
        String string3 = ServerSentEvents.newSseEvent(string, null, string2);
    }

    private static TimerTask newKeepAliveTask(final List<PrintWriter> list) {
        return new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List list2 = list;
                synchronized (list2) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        PrintWriter printWriter = (PrintWriter)iterator.next();
                        String string = ServerSentEvents.newKeepAliveEvent();
                        try {
                            printWriter.print(string);
                        }
                        catch (Exception exception) {
                            iterator.remove();
                        }
                    }
                }
            }
        };
    }

    private static String newKeepAliveEvent() {
        return "id: " + System.currentTimeMillis() + "\nevent: keep-alive\n\n";
    }

    private static String newSseEvent(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("id: ").append(string == null ? Long.valueOf(System.currentTimeMillis()) : string).append("\n");
        if (string2 != null) {
            stringBuilder.append("event: ").append("\n");
        }
        if (string3 != null) {
            stringBuilder.append("data: ").append(string3).append("\n");
        }
        return stringBuilder.append("\n").toString();
    }
}

