/*
 * Decompiled with CFR 0.152.
 */
package httpserver.session;

import httpserver.core.HttpServerExchange;
import httpserver.error.Forbidden;
import httpserver.session.SessionStore;
import httpserver.util.Encoding;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public interface TokenSessionStore<T>
extends SessionStore<T> {
    public byte[] getSessionValidationKey();

    @Override
    default public void setSession(HttpServerExchange httpServerExchange, T t) {
        String string = this.toSessionValue(t);
        httpServerExchange.setResponseHeader("Set-Cookie", this.getSessionCookieName() + "=" + string + this.getSessionCookieConfiguration());
    }

    @Override
    default public boolean existsSession(HttpServerExchange httpServerExchange) {
        try {
            return this.getSession(httpServerExchange, null) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    default public T getSession(HttpServerExchange httpServerExchange) throws IOException {
        T t = this.getSession(httpServerExchange, null);
        if (t == null) {
            throw new Forbidden();
        }
        return t;
    }

    @Override
    default public T getSession(HttpServerExchange httpServerExchange, T t) throws IOException {
        String string = SessionStore.getValueForCookie(httpServerExchange, this.getSessionCookieName(), null);
        if (string == null) {
            return t;
        }
        return this.fromSessionValue(string);
    }

    @Override
    default public void deleteSession(HttpServerExchange httpServerExchange) {
        String string = SessionStore.getValueForCookie(httpServerExchange, this.getSessionCookieName(), null);
        if (string == null) {
            return;
        }
        httpServerExchange.setResponseHeader("Set-Cookie", this.getSessionCookieName() + "=" + this.getSessionCookieConfiguration());
    }

    public byte[] sessionToJson(T var1, Charset var2);

    public T sessionFromJson(String var1);

    private String toSessionValue(T t) {
        String string = Encoding.encodeBase64Url(this.sessionToJson(t, StandardCharsets.UTF_8));
        return string + "." + TokenSessionStore.toVerification(this.getSessionValidationKey(), string);
    }

    default public T fromSessionValue(String string) throws Forbidden {
        String[] stringArray = string.split("\\.");
        if (TokenSessionStore.isValidSession(stringArray, this.getSessionValidationKey())) {
            throw new Forbidden("Invalid session");
        }
        return this.sessionFromJson(new String(Encoding.decodeBase64Url(stringArray[0]), StandardCharsets.UTF_8));
    }

    private static boolean isValidSession(String[] stringArray, byte[] byArray) {
        return stringArray != null && stringArray.length == 2 && stringArray[1].equals(TokenSessionStore.toVerification(byArray, stringArray[0]));
    }

    private static String toVerification(byte[] byArray, String string) {
        return Encoding.encodeBase64Url(Encoding.hmacSha256(string.getBytes(StandardCharsets.UTF_8), byArray));
    }
}

