/*
 * Decompiled with CFR 0.152.
 */
package httpserver.handlers;

import httpserver.HttpHandler;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class HostRouting {
    private HttpHandler fallback = httpServerExchange -> httpServerExchange.setStatusCode(404);
    private Map<String, HttpHandler> hosts = new HashMap<String, HttpHandler>();

    public static HostRouting hostRouting() {
        return new HostRouting();
    }

    public HostRouting host(String string, HttpHandler httpHandler) {
        this.hosts.put(string.toLowerCase(Locale.ENGLISH), httpHandler);
        return this;
    }

    public HostRouting fallback(HttpHandler httpHandler) {
        this.fallback = httpHandler;
        return this;
    }

    public HttpHandler build() {
        return httpServerExchange -> {
            String string = HostRouting.removePortSection(httpServerExchange.getRequestHeader("Host"));
            HttpHandler httpHandler = string == null ? this.fallback : this.hosts.getOrDefault(string.toLowerCase(Locale.ENGLISH), this.fallback);
            httpHandler.handleRequest(httpServerExchange);
        };
    }

    private static String removePortSection(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(58);
        return n == -1 ? string : string.substring(0, n);
    }
}

