/*
 * Decompiled with CFR 0.152.
 */
package httpserver.session;

import httpserver.core.HttpServerExchange;
import httpserver.error.Forbidden;
import httpserver.session.SessionStore;
import httpserver.util.Encoding;
import java.io.IOException;
import java.util.Random;

public interface RandomIdStore<T>
extends SessionStore<T> {
    default public int lengthSessionId() {
        return 32;
    }

    public Random prngSessionId();

    public void storeSession(String var1, T var2) throws IOException;

    public T retrieveSession(String var1) throws IOException;

    public void deleteSession(String var1) throws IOException;

    @Override
    default public void setSession(HttpServerExchange httpServerExchange, T t) throws IOException {
        byte[] byArray = new byte[this.lengthSessionId()];
        this.prngSessionId().nextBytes(byArray);
        String string = Encoding.encodeHex(byArray);
        this.storeSession(string, t);
        httpServerExchange.setResponseHeader("Set-Cookie", this.sessionCookieName() + "=" + string + this.sessionCookieConfiguration());
    }

    @Override
    default public boolean existsSession(HttpServerExchange httpServerExchange) {
        try {
            return this.getSession(httpServerExchange, null) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    default public T getSession(HttpServerExchange httpServerExchange) throws Forbidden, IOException {
        T t = this.getSession(httpServerExchange, null);
        if (t == null) {
            throw new Forbidden();
        }
        return t;
    }

    @Override
    default public T getSession(HttpServerExchange httpServerExchange, T t) throws IOException {
        String string = SessionStore.getValueForCookie(httpServerExchange, this.sessionCookieName(), null);
        if (string == null) {
            return t;
        }
        return this.retrieveSession(string);
    }

    @Override
    default public void deleteSession(HttpServerExchange httpServerExchange) throws IOException {
        String string = SessionStore.getValueForCookie(httpServerExchange, this.sessionCookieName(), null);
        if (string == null) {
            return;
        }
        this.deleteSession(string);
        httpServerExchange.setResponseHeader("Set-Cookie", this.sessionCookieName() + "=" + this.sessionCookieConfiguration());
    }
}

