/*
 * Decompiled with CFR 0.152.
 */
package httpserver.session;

import httpserver.core.HttpServerExchange;
import httpserver.error.InvalidInput;
import java.io.IOException;
import java.util.List;

public interface SessionStore<T> {
    default public String sessionCookieName() {
        return "session";
    }

    default public String sessionCookieConfiguration() {
        return "; Path=/; Secure; HttpOnly; SameSite=strict";
    }

    public void setSession(HttpServerExchange var1, T var2) throws IOException;

    public boolean existsSession(HttpServerExchange var1) throws IOException, InvalidInput;

    public T getSession(HttpServerExchange var1) throws IOException, InvalidInput;

    public T getSession(HttpServerExchange var1, T var2) throws IOException, InvalidInput;

    public void deleteSession(HttpServerExchange var1) throws IOException;

    public static String getValueForCookie(HttpServerExchange httpServerExchange, String string, String string2) {
        List<String> list = httpServerExchange.getRequestHeaders("Cookie");
        if (list == null || list.isEmpty()) {
            return string2;
        }
        String string3 = string + "=";
        for (String string4 : list) {
            for (String string5 : string4.split(";")) {
                if (!string5.trim().startsWith(string3)) continue;
                return string5.substring(string5.indexOf(61) + 1).trim();
            }
        }
        return string2;
    }
}

