/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.mappers;

import com.github.collinalpert.java2db.database.ForeignKey;
import com.github.collinalpert.java2db.database.ForeignKeyObject;
import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.services.BaseService;
import com.github.collinalpert.java2db.utilities.EmptyResultSetException;
import com.github.collinalpert.java2db.utilities.IoC;
import com.github.collinalpert.java2db.utilities.Utilities;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BaseMapper<T extends BaseEntity> {
    private Class<T> clazz;

    public BaseMapper(Class<T> clazz) {
        this.clazz = clazz;
    }

    public T map(ResultSet set) {
        BaseEntity entity = (BaseEntity)IoC.resolve(this.clazz);
        try {
            if (set.next()) {
                this.setFields(set, entity);
            } else if (this.isResultSetEmpty(set)) {
                throw new EmptyResultSetException(String.format("No entry found for query of type %s.", this.clazz.getSimpleName()));
            }
            set.close();
            return (T)entity;
        }
        catch (IllegalAccessException | SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<T> mapToList(ResultSet set) {
        ArrayList<BaseEntity> list = new ArrayList<BaseEntity>();
        try {
            while (set.next()) {
                BaseEntity entity = (BaseEntity)IoC.resolve(this.clazz);
                this.setFields(set, entity);
                list.add(entity);
            }
            set.close();
        }
        catch (IllegalAccessException | SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    private void setFields(ResultSet set, T entity) throws IllegalAccessException {
        ArrayList<Field> fields = Utilities.getAllFields(entity, true);
        try {
            Map<Integer, Integer> foreignKeys = this.getForeignKeys(fields, set);
            Map<Class<?>, Integer> foreignKeyObjects = this.getForeignKeyObjects(fields);
            for (Field field : fields) {
                field.setAccessible(true);
                if (field.getAnnotation(ForeignKeyObject.class) != null) {
                    ForeignKeyObject fkObject = field.getAnnotation(ForeignKeyObject.class);
                    Class clz = foreignKeyObjects.keySet().stream().filter(x -> x == field.getType()).findFirst().orElseThrow();
                    BaseService<?> service = IoC.resolveServiceByEntity(clz);
                    field.set(entity, service.getById(foreignKeys.get(fkObject.value())));
                    continue;
                }
                Object value = set.getObject(field.getName(), field.getType());
                field.set(entity, value);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Cannot use base mapping. Please define custom mapping in according mapping class.");
        }
    }

    private Map<Integer, Integer> getForeignKeys(ArrayList<Field> fields, ResultSet set) throws SQLException {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (Field field : fields) {
            ForeignKey key = field.getAnnotation(ForeignKey.class);
            if (key == null) continue;
            map.put(key.value(), set.getInt(field.getName()));
        }
        return map;
    }

    private Map<Class<?>, Integer> getForeignKeyObjects(ArrayList<Field> fields) {
        return fields.stream().filter(field -> field.getAnnotation(ForeignKeyObject.class) != null).collect(Collectors.toMap(Field::getType, field -> field.getAnnotation(ForeignKeyObject.class).value()));
    }

    private boolean isResultSetEmpty(ResultSet set) {
        try {
            return !set.isBeforeFirst();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return true;
        }
    }
}

