/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.utilities;

import com.github.collinalpert.java2db.database.ForeignKeyObject;
import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.utilities.SystemParameter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;

public class Utilities {
    public static <T extends BaseEntity> ArrayList<Field> getAllFields(T instance) {
        return Utilities.getAllFields(instance, null, false);
    }

    public static <T extends BaseEntity> ArrayList<Field> getAllFields(T instance, boolean includeForeignKeys) {
        return Utilities.getAllFields(instance, null, includeForeignKeys);
    }

    public static <T extends BaseEntity> ArrayList<Field> getAllFields(T instance, Class<?> delimiter) {
        return Utilities.getAllFields(instance, delimiter, false);
    }

    public static <T extends BaseEntity> ArrayList<Field> getAllFields(T instance, Class<?> delimiter, boolean includeForeignKeys) {
        Class<?> current = instance.getClass();
        ArrayList<Field> fields = new ArrayList<Field>();
        do {
            fields.addAll(Arrays.asList(current.getDeclaredFields()));
            if (includeForeignKeys) continue;
            fields.removeIf(x -> x.getAnnotation(ForeignKeyObject.class) != null);
        } while ((current = current.getSuperclass()) != delimiter);
        return fields;
    }

    public static void log(Object text) {
        if (SystemParameter.LOG_QUERIES) {
            System.out.println(text);
        }
    }

    public static void logf(String text, Object ... params) {
        Utilities.log(String.format(text, params));
    }
}

