/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.mappers;

import com.github.collinalpert.java2db.annotations.ForeignKeyObject;
import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.mappers.Mapper;
import com.github.collinalpert.java2db.utilities.IoC;
import com.github.collinalpert.java2db.utilities.UniqueIdentifier;
import com.github.collinalpert.java2db.utilities.Utilities;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class BaseMapper<T extends BaseEntity>
implements Mapper<T> {
    private Class<T> clazz;

    public BaseMapper(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public Optional<T> map(ResultSet set) throws SQLException {
        BaseEntity entity = (BaseEntity)IoC.resolve(this.clazz);
        try (ResultSet resultSet = set;){
            if (!set.next()) {
                UniqueIdentifier.unset();
                Optional optional = Optional.empty();
                return optional;
            }
            this.setFields(set, entity);
            UniqueIdentifier.unset();
            Optional<BaseEntity> optional = Optional.of(entity);
            return optional;
        }
    }

    @Override
    public List<T> mapToList(ResultSet set) throws SQLException {
        ArrayList<BaseEntity> list = new ArrayList<BaseEntity>();
        try (ResultSet resultSet = set;){
            while (set.next()) {
                BaseEntity entity = (BaseEntity)IoC.resolve(this.clazz);
                this.setFields(set, entity);
                list.add(entity);
            }
        }
        UniqueIdentifier.unset();
        return list;
    }

    private <E extends BaseEntity> void setFields(ResultSet set, E entity) throws SQLException {
        this.setFields(set, entity, null);
    }

    private <E extends BaseEntity> void setFields(ResultSet set, E entity, String identifier) throws SQLException {
        List<Field> fields = Utilities.getEntityFields(entity.getClass(), true);
        String tableName = Utilities.getTableName(entity.getClass());
        LinkedList<Field> foreignKeyFields = new LinkedList<Field>();
        for (Field field : fields) {
            field.setAccessible(true);
            try {
                if (field.getAnnotation(ForeignKeyObject.class) != null) {
                    if (!BaseEntity.class.isAssignableFrom(field.getType())) {
                        throw new IllegalArgumentException(String.format("Type %s which is annotated as a foreign key, does not extend BaseEntity", field.getType().getSimpleName()));
                    }
                    foreignKeyFields.add(field);
                    BaseEntity foreignKeyObject = (BaseEntity)IoC.resolve(field.getType());
                    this.setFields(set, foreignKeyObject, UniqueIdentifier.getIdentifier(field.getName()));
                    field.set(entity, foreignKeyObject);
                    continue;
                }
                Object value = set.getObject((identifier == null ? tableName : identifier) + "_" + field.getName());
                if (value == null) continue;
                field.set(entity, value);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        this.validateEntityForNull(entity, foreignKeyFields);
    }

    private <E extends BaseEntity> void validateEntityForNull(E entity, List<Field> foreignKeyFields) {
        foreignKeyFields.forEach(field -> {
            String foreignKeyText = field.getAnnotation(ForeignKeyObject.class).value();
            try {
                field.setAccessible(true);
                Field foreignKeyField = entity.getClass().getDeclaredField(foreignKeyText);
                foreignKeyField.setAccessible(true);
                Object value = foreignKeyField.get(entity);
                if (value == null) {
                    field.set(entity, null);
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        });
    }
}

