/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.services;

import com.github.collinalpert.java2db.database.DBConnection;
import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.exceptions.IllegalEntityFieldAccessException;
import com.github.collinalpert.java2db.mappers.BaseMapper;
import com.github.collinalpert.java2db.mappers.Mapper;
import com.github.collinalpert.java2db.pagination.CacheablePaginationResult;
import com.github.collinalpert.java2db.pagination.PaginationResult;
import com.github.collinalpert.java2db.queries.OrderTypes;
import com.github.collinalpert.java2db.queries.Query;
import com.github.collinalpert.java2db.utilities.IoC;
import com.github.collinalpert.java2db.utilities.Utilities;
import com.github.collinalpert.lambda2sql.Lambda2Sql;
import com.github.collinalpert.lambda2sql.functions.SqlFunction;
import com.github.collinalpert.lambda2sql.functions.SqlPredicate;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public class BaseService<T extends BaseEntity> {
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss");
    private final Class<T> type = this.getGenericType();
    private final String tableName;
    private final Mapper<T> mapper = IoC.resolveMapperOrElse(this.type, new BaseMapper<T>(this.type));

    protected BaseService() {
        this.tableName = String.format("`%s`", Utilities.getTableName(this.type));
    }

    public long create(T instance) throws SQLException {
        StringBuilder insertQuery = this.createInsertHeader();
        StringJoiner joiner = new StringJoiner(",", "(", ");");
        Utilities.getEntityFields(instance.getClass(), BaseEntity.class).forEach(field -> {
            field.setAccessible(true);
            joiner.add(this.getSQLValue((Field)field, instance));
        });
        joiner.add("default");
        insertQuery.append(joiner.toString());
        try (DBConnection connection = new DBConnection();){
            long id = connection.update(insertQuery.toString());
            Utilities.logf("%s successfully created!", this.type.getSimpleName());
            long l = id;
            return l;
        }
    }

    @SafeVarargs
    public final void createMultiple(T ... instances) throws SQLException {
        this.createMultiple(Arrays.asList(instances));
    }

    public void createMultiple(List<T> instances) throws SQLException {
        if (instances.isEmpty()) {
            return;
        }
        StringBuilder insertQuery = this.createInsertHeader();
        CharSequence[] rows = new String[instances.size()];
        int instancesSize = instances.size();
        for (int i = 0; i < instancesSize; ++i) {
            List<Field> entityFields = Utilities.getEntityFields(((BaseEntity)instances.get(i)).getClass(), BaseEntity.class);
            StringJoiner joiner = new StringJoiner(", ", "(", ")");
            for (Field entityField : entityFields) {
                entityField.setAccessible(true);
                joiner.add(this.getSQLValue(entityField, (BaseEntity)instances.get(i)));
            }
            joiner.add("default");
            rows[i] = joiner.toString();
        }
        insertQuery.append(String.join((CharSequence)", ", rows));
        try (DBConnection connection = new DBConnection();){
            connection.update(insertQuery.toString());
            Utilities.logf("%s entities were successfully created.", this.type.getSimpleName());
        }
    }

    public long count() {
        return this.count(x -> true);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public long count(SqlPredicate<T> predicate) {
        try (DBConnection connection = new DBConnection();){
            long l;
            block17: {
                ResultSet result;
                block15: {
                    long l2;
                    block16: {
                        result = connection.execute(String.format("select count(id) from %s where %s;", this.tableName, Lambda2Sql.toSql(predicate, this.tableName)));
                        try {
                            if (!result.next()) break block15;
                            l2 = result.getLong("count(id)");
                            if (result == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        result.close();
                    }
                    return l2;
                }
                l = 0L;
                if (result == null) break block17;
                result.close();
            }
            return l;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(String.format("Could not get amount of rows in table %s for this predicate.", this.tableName));
        }
    }

    public boolean any() {
        return this.any(x -> true);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean any(SqlPredicate<T> predicate) {
        try (DBConnection connection = new DBConnection();){
            boolean bl;
            block17: {
                ResultSet result;
                block15: {
                    boolean bl2;
                    block16: {
                        result = connection.execute(String.format("select exists(select id from %s where %s limit 1) as result;", this.tableName, Lambda2Sql.toSql(predicate)));
                        try {
                            if (!result.next()) break block15;
                            boolean bl3 = bl2 = result.getInt("result") == 1;
                            if (result == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        result.close();
                    }
                    return bl2;
                }
                bl = false;
                if (result == null) break block17;
                result.close();
            }
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(String.format("Could not check if a row matches this condition on table %s.", this.tableName));
        }
    }

    protected Query<T> createQuery() {
        return new Query<T>(this.type, this.mapper);
    }

    protected Optional<T> getSingle(SqlPredicate<T> predicate) {
        return this.createQuery().where(predicate).getFirst();
    }

    protected Query<T> getMultiple(SqlPredicate<T> predicate) {
        return this.createQuery().where(predicate);
    }

    public Optional<T> getById(long id) {
        return this.getSingle(x -> x.getId() == id);
    }

    public List<T> getAll() {
        return this.createQuery().toList();
    }

    public List<T> getAll(int limit) {
        return this.createQuery().limit(limit).toList();
    }

    public List<T> getAll(SqlFunction<T, ?> orderBy) {
        return this.getAll(orderBy, OrderTypes.ASCENDING);
    }

    public List<T> getAll(SqlFunction<T, ?> orderBy, OrderTypes sortingType) {
        return this.createQuery().orderBy(sortingType, orderBy).toList();
    }

    public List<T> getAll(SqlFunction<T, ?> orderBy, int limit) {
        return this.getAll(orderBy, OrderTypes.ASCENDING, limit);
    }

    public List<T> getAll(SqlFunction<T, ?> orderBy, OrderTypes sortingType, int limit) {
        return this.createQuery().orderBy(sortingType, orderBy).limit(limit).toList();
    }

    public PaginationResult<T> createPagination(int entriesPerPage) {
        return new PaginationResult<T>(this.createPaginationQueries(entriesPerPage));
    }

    public PaginationResult<T> createPagination(SqlPredicate<T> predicate, int entriesPerPage) {
        return new PaginationResult<T>(this.createPaginationQueries(predicate, entriesPerPage));
    }

    public CacheablePaginationResult<T> createPagination(int entriesPerPage, Duration cacheExpiration) {
        return new CacheablePaginationResult<T>(this.createPaginationQueries(entriesPerPage), cacheExpiration);
    }

    public CacheablePaginationResult<T> createPagination(SqlPredicate<T> predicate, int entriesPerPage, Duration cacheExpiration) {
        return new CacheablePaginationResult<T>(this.createPaginationQueries(predicate, entriesPerPage), cacheExpiration);
    }

    public void update(T instance) throws SQLException {
        StringBuilder updateQuery = new StringBuilder("update ").append(this.tableName).append(" set ");
        StringJoiner fieldJoiner = new StringJoiner(", ");
        Utilities.getEntityFields(instance.getClass(), BaseEntity.class).forEach(field -> {
            field.setAccessible(true);
            fieldJoiner.add(String.format("`%s` = %s", Utilities.getColumnName(field), this.getSQLValue((Field)field, instance)));
        });
        updateQuery.append(fieldJoiner.toString()).append(" where id = ").append(((BaseEntity)instance).getId());
        try (DBConnection connection = new DBConnection();){
            connection.update(updateQuery.toString());
            Utilities.logf("%s with id %d was successfully updated.", this.type.getSimpleName(), ((BaseEntity)instance).getId());
        }
    }

    public <R> void update(long entityId, SqlFunction<T, R> column, R newValue) throws SQLException {
        StringBuilder query = new StringBuilder("update ");
        query.append(this.tableName).append(" set ").append(Lambda2Sql.toSql(column, this.tableName)).append(" = ").append(this.convertObject(newValue)).append(" where ").append(this.tableName).append(".id = ").append(entityId).append(';');
        try (DBConnection connection = new DBConnection();){
            connection.update(query.toString());
            Utilities.logf("%s with id %d was successfully updated.", this.type.getSimpleName(), entityId);
        }
    }

    public void delete(T instance) throws SQLException {
        this.delete(((BaseEntity)instance).getId());
    }

    public void delete(long id) throws SQLException {
        try (DBConnection connection = new DBConnection();){
            connection.update(String.format("delete from %s where %s.id = ?;", this.tableName, this.tableName), id);
            Utilities.logf("%s with id %s successfully deleted!", this.type.getSimpleName(), id);
        }
    }

    public void delete(List<T> entities) throws SQLException {
        try (DBConnection connection = new DBConnection();){
            StringJoiner joiner = new StringJoiner(", ", "(", ")");
            for (BaseEntity entity : entities) {
                joiner.add(Long.toString(entity.getId()));
            }
            String joinedIds = joiner.toString();
            connection.update(String.format("delete from %s where %s.id in %s", this.tableName, this.tableName, joinedIds));
            Utilities.logf("%s with ids %s successfully deleted!", this.type.getSimpleName(), joinedIds);
        }
    }

    @SafeVarargs
    public final void delete(T ... entities) throws SQLException {
        this.delete(Arrays.asList(entities));
    }

    public void delete(long ... ids) throws SQLException {
        try (DBConnection connection = new DBConnection();){
            StringJoiner joiner = new StringJoiner(", ", "(", ")");
            for (long id : ids) {
                joiner.add(Long.toString(id));
            }
            String joinedIds = joiner.toString();
            connection.update(String.format("delete from %s where %s.id in %s", this.tableName, this.tableName, joinedIds));
            Utilities.logf("%s with ids %s successfully deleted!", this.type.getSimpleName(), joinedIds);
        }
    }

    public void delete(SqlPredicate<T> predicate) throws SQLException {
        try (DBConnection connection = new DBConnection();){
            connection.update(String.format("delete from %s where %s;", this.tableName, Lambda2Sql.toSql(predicate, this.tableName)));
            Utilities.logf("%s successfully deleted!", this.type.getSimpleName());
        }
    }

    public void truncateTable() throws SQLException {
        try (DBConnection connection = new DBConnection();){
            connection.update(String.format("truncate table %s;", this.tableName));
            Utilities.logf("Table %s was successfully truncated.", this.tableName);
        }
    }

    private Class<T> getGenericType() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    private StringBuilder createInsertHeader() {
        return new StringBuilder("insert into ").append(this.tableName).append(Utilities.getEntityFields(this.type).stream().map(field -> String.format("`%s`", Utilities.getColumnName(field))).collect(Collectors.joining(", ", " (", ")"))).append(" values ");
    }

    private String getSQLValue(Field entityField, T entityInstance) {
        try {
            return this.convertObject(entityField.get(entityInstance));
        }
        catch (IllegalAccessException e) {
            throw new IllegalEntityFieldAccessException(entityField.getName(), this.type.getSimpleName(), e.getMessage());
        }
    }

    private String convertObject(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return "'" + value + "'";
        }
        if (value instanceof Boolean) {
            boolean bool = (Boolean)value;
            return bool ? "1" : "0";
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime dateTime = (LocalDateTime)value;
            return "'" + dateTimeFormatter.format(dateTime) + "'";
        }
        if (value instanceof LocalDate) {
            LocalDate date = (LocalDate)value;
            return "'" + dateFormatter.format(date) + "'";
        }
        if (value instanceof LocalTime) {
            LocalTime time = (LocalTime)value;
            return "'" + timeFormatter.format(time) + "'";
        }
        return value.toString();
    }

    private List<Query<T>> createPaginationQueries(int entriesPerPage) {
        return this.createPaginationQueries(x -> true, entriesPerPage);
    }

    private List<Query<T>> createPaginationQueries(SqlPredicate<T> predicate, int entriesPerPage) {
        long count = this.count(predicate);
        double numberOfPages = Math.ceil((double)count / (double)entriesPerPage);
        ArrayList<Query<T>> queries = new ArrayList<Query<T>>((int)numberOfPages);
        int i = 0;
        while ((double)i < numberOfPages) {
            int offset = i * entriesPerPage;
            queries.add(this.getMultiple(predicate).limit(entriesPerPage, offset));
            ++i;
        }
        return queries;
    }
}

