/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.queries;

import com.github.collinalpert.java2db.annotations.ForeignKeyEntity;
import com.github.collinalpert.java2db.database.DBConnection;
import com.github.collinalpert.java2db.database.ForeignKeyReference;
import com.github.collinalpert.java2db.database.TableColumnReference;
import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.mappers.IMapper;
import com.github.collinalpert.java2db.queries.OrderTypes;
import com.github.collinalpert.java2db.queries.QueryConstraints;
import com.github.collinalpert.java2db.utilities.Utilities;
import com.github.collinalpert.lambda2sql.Lambda2Sql;
import com.github.collinalpert.lambda2sql.functions.SqlFunction;
import com.github.collinalpert.lambda2sql.functions.SqlPredicate;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Array;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class Query<T extends BaseEntity> {
    private final Class<T> type;
    private final IMapper<T> mapper;
    private SqlPredicate<T> whereClause;
    private SqlFunction<T, ?>[] orderBy;
    private OrderTypes orderType;
    private Integer limit;
    private int limitOffset;

    public Query(Class<T> type, IMapper<T> mapper) {
        this.type = type;
        this.mapper = mapper;
    }

    public CompletableFuture<Optional<T>> getFirstAsync() {
        return CompletableFuture.supplyAsync(this::getFirst);
    }

    public CompletableFuture<Void> getFirstAsync(Consumer<? super Optional<T>> callback) {
        return this.getFirstAsync().thenAcceptAsync(callback);
    }

    public CompletableFuture<List<T>> toListAsync() {
        return CompletableFuture.supplyAsync(this::toList);
    }

    public CompletableFuture<Void> toListAsync(Consumer<? super List<T>> callback) {
        return this.toListAsync().thenAcceptAsync(callback);
    }

    public CompletableFuture<Stream<T>> toStreamAsync() {
        return CompletableFuture.supplyAsync(this::toStream);
    }

    public CompletableFuture<Void> toStreamAsync(Consumer<? super Stream<T>> callback) {
        return this.toStreamAsync().thenAcceptAsync(callback);
    }

    public CompletableFuture<T[]> toArrayAsync() {
        return CompletableFuture.supplyAsync((Supplier<BaseEntity[]>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toArray(), ()[Lcom/github/collinalpert/java2db/entities/BaseEntity;)((Query)this));
    }

    public CompletableFuture<Void> toArrayAsync(Consumer<? super T[]> callback) {
        return this.toArrayAsync().thenAcceptAsync(callback);
    }

    public Optional<T> getFirst() {
        DBConnection connection = new DBConnection();
        try {
            Optional<T> optional = this.mapper.map(connection.execute(this.buildQuery()));
            connection.close();
            return optional;
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return Optional.empty();
            }
        }
    }

    public List<T> toList() {
        DBConnection connection = new DBConnection();
        try {
            List<T> list = this.mapper.mapToList(connection.execute(this.buildQuery()));
            connection.close();
            return list;
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return Collections.emptyList();
            }
        }
    }

    public Stream<T> toStream() {
        DBConnection connection = new DBConnection();
        try {
            Stream<T> stream = this.mapper.mapToStream(connection.execute(this.buildQuery()));
            connection.close();
            return stream;
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return Stream.empty();
            }
        }
    }

    public T[] toArray() {
        DBConnection connection = new DBConnection();
        try {
            BaseEntity[] baseEntityArray = this.mapper.mapToArray(connection.execute(this.buildQuery()));
            connection.close();
            return baseEntityArray;
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return (BaseEntity[])Array.newInstance(this.type, 0);
            }
        }
    }

    public Query<T> where(SqlPredicate<T> predicate) {
        this.whereClause = this.whereClause == null ? predicate : this.whereClause.and(predicate);
        return this;
    }

    public Query<T> orWhere(SqlPredicate<T> predicate) {
        this.whereClause = this.whereClause == null ? predicate : this.whereClause.or(predicate);
        return this;
    }

    @SafeVarargs
    public final Query<T> orderBy(SqlFunction<T, ?> ... functions) {
        return this.orderBy(OrderTypes.ASCENDING, functions);
    }

    @SafeVarargs
    public final Query<T> orderBy(OrderTypes type, SqlFunction<T, ?> ... functions) {
        this.orderBy = functions;
        this.orderType = type;
        return this;
    }

    public Query<T> limit(int limit, int offset) {
        this.limit = limit;
        this.limitOffset = offset;
        return this;
    }

    public Query<T> limit(int limit) {
        this.limit = limit;
        return this;
    }

    private String buildQuery() {
        StringBuilder builder = new StringBuilder("select ");
        LinkedList<String> fieldList = new LinkedList<String>();
        LinkedList<ForeignKeyReference> foreignKeyList = new LinkedList<ForeignKeyReference>();
        String tableName = Utilities.getTableName(this.type);
        List<TableColumnReference> columns = Utilities.getAllFields(this.type);
        for (TableColumnReference column : columns) {
            if (column.isForeignKey()) {
                foreignKeyList.add(new ForeignKeyReference(column.getReference(), column.getColumn().getAnnotation(ForeignKeyEntity.class).value(), Utilities.getTableName(column.getColumn().getType()), column.getAlias()));
                continue;
            }
            fieldList.add(String.format("%s as %s", column.getSQLNotation(), column.getAliasNotation()));
        }
        builder.append(String.join((CharSequence)", ", fieldList)).append(" from `").append(tableName).append("`");
        for (ForeignKeyReference foreignKey : foreignKeyList) {
            builder.append(" left join `").append(foreignKey.getChildTable()).append("` ").append(foreignKey.getAlias()).append(" on `").append(foreignKey.getParentClass()).append("`.`").append(foreignKey.getParentForeignKey()).append("` = `").append(foreignKey.getAlias()).append("`.`id`");
        }
        SqlPredicate<T> constraints = QueryConstraints.getConstraints(this.type);
        SqlPredicate<T> clauseCopy = this.whereClause;
        clauseCopy = clauseCopy == null ? constraints : clauseCopy.and(constraints);
        builder.append(" where ").append(Lambda2Sql.toSql(clauseCopy, tableName));
        if (this.orderBy != null && this.orderBy.length > 0) {
            builder.append(" order by ");
            if (this.orderBy.length == 1) {
                builder.append(Lambda2Sql.toSql(this.orderBy[0], tableName));
            } else {
                StringJoiner joiner = new StringJoiner(", ", "coalesce(", ")");
                for (SqlFunction<T, ?> orderByFunction : this.orderBy) {
                    joiner.add(Lambda2Sql.toSql(orderByFunction, tableName));
                }
                builder.append(joiner.toString());
            }
            builder.append(" ").append(this.orderType.getSql());
        }
        if (this.limit != null) {
            builder.append(" limit ").append(this.limitOffset).append(", ").append(this.limit);
        }
        return builder.toString();
    }

    public String getQuery() {
        return this.buildQuery();
    }

    public String toString() {
        return this.buildQuery();
    }
}

