/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.database;

import com.github.collinalpert.java2db.database.ConnectionConfiguration;
import com.github.collinalpert.java2db.exceptions.ConnectionFailedException;
import com.github.collinalpert.java2db.mappers.FieldMapper;
import com.github.collinalpert.java2db.queries.Queryable;
import com.github.collinalpert.java2db.queries.StoredProcedureQuery;
import com.github.collinalpert.java2db.queries.async.AsyncQueryable;
import com.github.collinalpert.java2db.queries.async.AsyncStoredProcedureQuery;
import com.github.collinalpert.java2db.utilities.Utilities;
import com.mysql.cj.exceptions.CJCommunicationsException;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class DBConnection
implements Closeable {
    public static boolean LOG_QUERIES = true;
    private final Connection underlyingConnection;
    private boolean isConnectionValid;

    public DBConnection(ConnectionConfiguration configuration) {
        try {
            String connectionString = String.format("jdbc:mysql://%s:%d/%s?rewriteBatchedStatements=true", configuration.getHost(), configuration.getPort(), configuration.getDatabase());
            System.setProperty("user", configuration.getUsername());
            System.setProperty("password", configuration.getPassword());
            DriverManager.setLoginTimeout(configuration.getTimeout());
            this.underlyingConnection = DriverManager.getConnection(connectionString, System.getProperties());
            this.isConnectionValid = true;
        }
        catch (CJCommunicationsException | SQLException e) {
            this.isConnectionValid = false;
            throw new ConnectionFailedException(e);
        }
    }

    public DBConnection(Connection underlyingConnection) {
        this.underlyingConnection = underlyingConnection;
        this.isConnectionValid = true;
    }

    public boolean isValid() {
        return this.isConnectionValid;
    }

    public ResultSet execute(String query) throws SQLException {
        Statement statement = this.underlyingConnection.createStatement();
        this.log(query);
        ResultSet set = statement.executeQuery(query);
        statement.closeOnCompletion();
        return set;
    }

    public ResultSet execute(String query, Object ... params) throws SQLException {
        PreparedStatement statement = this.underlyingConnection.prepareStatement(query);
        for (int i = 0; i < params.length; ++i) {
            statement.setObject(i + 1, params[i]);
        }
        this.log(query);
        ResultSet set = statement.executeQuery();
        statement.closeOnCompletion();
        return set;
    }

    public int update(String query) throws SQLException {
        Statement statement = this.underlyingConnection.createStatement();
        this.log(query);
        statement.executeUpdate(query, 1);
        return this.updateInternal(statement);
    }

    public int update(String query, Object ... params) throws SQLException {
        PreparedStatement statement = this.underlyingConnection.prepareStatement(query, 1);
        for (int i = 0; i < params.length; ++i) {
            statement.setObject(i + 1, params[i]);
        }
        this.log(query);
        statement.executeUpdate();
        return this.updateInternal(statement);
    }

    public boolean isOpen() {
        try {
            return !this.underlyingConnection.isClosed();
        }
        catch (SQLException e) {
            System.err.println("Could not determine connection status");
            this.isConnectionValid = false;
            return false;
        }
    }

    @Override
    public void close() {
        try {
            if (this.underlyingConnection != null) {
                this.underlyingConnection.close();
            }
        }
        catch (SQLException e) {
            System.err.println("Could not close database connection");
            e.printStackTrace();
        }
        finally {
            this.isConnectionValid = false;
        }
    }

    public <T> Optional<T> callFunction(Class<T> returnType, String functionName, Object ... arguments) throws SQLException {
        StringJoiner joiner = new StringJoiner(",");
        for (int i = 0; i < arguments.length; ++i) {
            joiner.add("?");
        }
        try (ResultSet set = this.execute(String.format("select %s(%s);", functionName, joiner), arguments);){
            Optional<T> optional = new FieldMapper<T>(returnType).map(set);
            return optional;
        }
    }

    public <T> CompletableFuture<Optional<T>> callFunctionAsync(Consumer<SQLException> exceptionHandler, Class<T> returnType, String functionName, Object ... arguments) {
        return CompletableFuture.supplyAsync(Utilities.supplierHandling(() -> this.callFunction(returnType, functionName, arguments), exceptionHandler));
    }

    public <T> CompletableFuture<Optional<T>> callFunctionAsync(Class<T> returnType, String functionName, Object ... arguments) {
        return CompletableFuture.supplyAsync(Utilities.supplierHandling(() -> this.callFunction(returnType, functionName, arguments)));
    }

    public <T> CompletableFuture<Void> callFunctionAsync(Class<T> returnType, Consumer<? super Optional<T>> callback, String functionName, Object ... arguments) {
        return CompletableFuture.supplyAsync(Utilities.supplierHandling(() -> this.callFunction(returnType, functionName, arguments))).thenAcceptAsync(callback);
    }

    public <T> CompletableFuture<Void> callFunctionAsync(Consumer<SQLException> exceptionHandler, Class<T> returnType, Consumer<? super Optional<T>> callback, String functionName, Object ... arguments) {
        return CompletableFuture.supplyAsync(Utilities.supplierHandling(() -> this.callFunction(returnType, functionName, arguments), exceptionHandler)).thenAcceptAsync(callback);
    }

    public <T> Queryable<T> callStoredProcedure(Class<T> returnType, String storedProcedureName, Object ... arguments) {
        return new StoredProcedureQuery<T>(returnType, this, storedProcedureName, arguments);
    }

    public <T> AsyncQueryable<T> callStoredProcedureAsync(Class<T> returnType, String storedProcedureName, Object ... arguments) {
        return new AsyncStoredProcedureQuery<T>(returnType, this, storedProcedureName, arguments);
    }

    public Connection underlyingConnection() {
        return this.underlyingConnection;
    }

    private void log(String text) {
        if (LOG_QUERIES) {
            System.out.println(text);
        }
    }

    private int updateInternal(Statement statement) throws SQLException {
        statement.closeOnCompletion();
        ResultSet set = statement.getGeneratedKeys();
        if (set.next()) {
            return set.getInt(1);
        }
        return -1;
    }

    static {
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

