/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.queries;

import com.github.collinalpert.expressions.expression.LambdaExpression;
import com.github.collinalpert.java2db.database.ConnectionConfiguration;
import com.github.collinalpert.java2db.database.DBConnection;
import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.mappers.EntityMapper;
import com.github.collinalpert.java2db.mappers.Mappable;
import com.github.collinalpert.java2db.modules.TableModule;
import com.github.collinalpert.java2db.queries.QueryParameters;
import com.github.collinalpert.java2db.queries.Queryable;
import com.github.collinalpert.java2db.queries.SingleEntityProjectionQuery;
import com.github.collinalpert.java2db.queries.builder.IQueryBuilder;
import com.github.collinalpert.java2db.queries.builder.ProjectionQueryBuilder;
import com.github.collinalpert.java2db.queries.builder.QueryBuilder;
import com.github.collinalpert.java2db.queries.builder.SingleEntityQueryBuilder;
import com.github.collinalpert.java2db.utilities.IoC;
import com.github.collinalpert.lambda2sql.functions.SqlFunction;
import com.github.collinalpert.lambda2sql.functions.SqlPredicate;
import java.lang.reflect.Array;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

public class SingleEntityQuery<E extends BaseEntity>
implements Queryable<E> {
    private static final TableModule tableModule = TableModule.getInstance();
    protected final QueryParameters<E> queryParameters;
    protected final IQueryBuilder<E> queryBuilder;
    protected final ConnectionConfiguration connectionConfiguration;
    private final Class<E> type;
    private final Mappable<E> mapper;

    public SingleEntityQuery(Class<E> type, ConnectionConfiguration connectionConfiguration) {
        this.type = type;
        this.queryParameters = new QueryParameters();
        this.mapper = IoC.resolveMapper(type, new EntityMapper<E>(type));
        this.queryBuilder = new SingleEntityQueryBuilder<E>(type);
        this.connectionConfiguration = connectionConfiguration;
    }

    public SingleEntityQuery<E> where(SqlPredicate<E> predicate) {
        this.queryParameters.appendLogicalAndWhereClause(predicate);
        return this;
    }

    public SingleEntityQuery<E> orWhere(SqlPredicate<E> predicate) {
        this.queryParameters.appendLogicalOrWhereClause(predicate);
        return this;
    }

    public <R> Queryable<R> project(SqlFunction<E, R> projection) {
        Class<?> returnType = LambdaExpression.parse(projection).getBody().getResultType();
        ProjectionQueryBuilder<E, R> queryBuilder = new ProjectionQueryBuilder<E, R>(projection, this.getTableName(), (QueryBuilder)this.queryBuilder);
        return new SingleEntityProjectionQuery(returnType, queryBuilder, this.queryParameters, this.connectionConfiguration);
    }

    @Override
    public Optional<E> first() {
        DBConnection connection = new DBConnection(this.connectionConfiguration);
        try {
            Optional<E> optional = this.mapper.map(connection.execute(this.getQuery()));
            connection.close();
            return optional;
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return Optional.empty();
            }
        }
    }

    @Override
    public List<E> toList() {
        DBConnection connection = new DBConnection(this.connectionConfiguration);
        try {
            Optional<E> mappedValue = this.mapper.map(connection.execute(this.getQuery()));
            List list = mappedValue.map(Collections::singletonList).orElse(Collections.emptyList());
            connection.close();
            return list;
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return Collections.emptyList();
            }
        }
    }

    @Override
    public Stream<E> toStream() {
        DBConnection connection = new DBConnection(this.connectionConfiguration);
        try {
            Optional<E> mappedValue = this.mapper.map(connection.execute(this.getQuery()));
            Stream<E> stream = mappedValue.stream();
            connection.close();
            return stream;
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return Stream.empty();
            }
        }
    }

    @Override
    public E[] toArray() {
        DBConnection connection = new DBConnection(this.connectionConfiguration);
        try {
            Optional<E> mappedValue = this.mapper.map(connection.execute(this.getQuery()));
            BaseEntity[] baseEntityArray = mappedValue.map(v -> {
                BaseEntity[] array = (BaseEntity[])Array.newInstance(this.type, 1);
                array[0] = v;
                return array;
            }).orElse((BaseEntity[])Array.newInstance(this.type, 0));
            connection.close();
            return baseEntityArray;
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return (BaseEntity[])Array.newInstance(this.type, 0);
            }
        }
    }

    @Override
    public <K, V> Map<K, V> toMap(Function<E, K> keyMapping, Function<E, V> valueMapping) {
        DBConnection connection = new DBConnection(this.connectionConfiguration);
        try {
            Optional<E> mappedValue = this.mapper.map(connection.execute(this.getQuery()));
            Map map = mappedValue.map(v -> Collections.singletonMap(keyMapping.apply(v), valueMapping.apply(v))).orElse(Collections.emptyMap());
            connection.close();
            return map;
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return Collections.emptyMap();
            }
        }
    }

    @Override
    public Set<E> toSet() {
        DBConnection connection = new DBConnection(this.connectionConfiguration);
        try {
            Optional<E> mappedValue = this.mapper.map(connection.execute(this.getQuery()));
            Set set = mappedValue.map(Collections::singleton).orElse(Collections.emptySet());
            connection.close();
            return set;
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return Collections.emptySet();
            }
        }
    }

    @Override
    public String getQuery() {
        return this.queryBuilder.build(this.queryParameters);
    }

    protected String getTableName() {
        return tableModule.getTableName(this.type);
    }
}

