/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.queries.builder;

import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.queries.QueryParameters;
import com.github.collinalpert.java2db.queries.builder.QueryBuilder;
import com.github.collinalpert.java2db.queries.ordering.OrderByClause;
import com.github.collinalpert.lambda2sql.Lambda2Sql;
import com.github.collinalpert.lambda2sql.functions.SqlFunction;
import java.util.List;
import java.util.StringJoiner;

public class EntityQueryBuilder<E extends BaseEntity>
extends QueryBuilder<E> {
    public EntityQueryBuilder(Class<E> type) {
        super(type);
    }

    @Override
    String buildQueryClauses(QueryParameters<E> queryParameters) {
        OrderByClause<E> orderByClause;
        StringBuffer buffer = new StringBuffer(" ");
        this.appendWhereClause(buffer, queryParameters.getWhereClause());
        List<SqlFunction<E, ?>> groupByClause = queryParameters.getGroupByClause();
        if (groupByClause != null) {
            StringJoiner joiner = new StringJoiner(", ", "group by ", "");
            for (SqlFunction<E, ?> groupBy : groupByClause) {
                joiner.add(Lambda2Sql.toSql(groupBy, this.tableName));
            }
            buffer.append(' ').append(joiner.toString());
        }
        if ((orderByClause = queryParameters.getOrderByClause()) != null) {
            buffer.append(' ').append(orderByClause.buildSql(this.tableName));
        }
        if (queryParameters.getLimit() != null) {
            buffer.append(" limit ").append(queryParameters.getLimitOffset()).append(", ").append(queryParameters.getLimit());
        }
        return buffer.toString();
    }
}

