/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.queries.builder;

import com.github.collinalpert.java2db.database.ForeignKeyReference;
import com.github.collinalpert.java2db.database.TableColumnReference;
import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.modules.FieldModule;
import com.github.collinalpert.java2db.modules.TableModule;
import com.github.collinalpert.java2db.queries.QueryConstraints;
import com.github.collinalpert.java2db.queries.QueryParameters;
import com.github.collinalpert.java2db.queries.builder.IQueryBuilder;
import com.github.collinalpert.lambda2sql.Lambda2Sql;
import com.github.collinalpert.lambda2sql.functions.SqlPredicate;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class QueryBuilder<E extends BaseEntity>
implements IQueryBuilder<E> {
    static final TableModule tableModule = TableModule.getInstance();
    private static final FieldModule fieldModule = FieldModule.getInstance();
    protected final String tableName;
    private final Class<E> type;

    public QueryBuilder(Class<E> type) {
        this.type = type;
        this.tableName = tableModule.getTableName(this.type);
    }

    protected void appendWhereClause(StringBuffer buffer, SqlPredicate<E> whereClause) {
        SqlPredicate<E> constraints = QueryConstraints.getConstraints(this.type);
        whereClause = whereClause == null ? constraints : whereClause.and(constraints);
        buffer.append("where ").append(Lambda2Sql.toSql(whereClause, this.tableName));
    }

    @Override
    public String build(QueryParameters<E> queryParameters) {
        StringBuilder builder = new StringBuilder("select ");
        LinkedList<String> fieldList = new LinkedList<String>();
        List<TableColumnReference> columns = fieldModule.getColumnReferences(this.type);
        Iterator<TableColumnReference> columnIterator = columns.iterator();
        while (columnIterator.hasNext()) {
            TableColumnReference column = columnIterator.next();
            if (column instanceof ForeignKeyReference) continue;
            fieldList.add(String.format("%s as %s", column.getSQLNotation(), column.getAliasNotation()));
            columnIterator.remove();
        }
        if (queryParameters.getDistinct()) {
            builder.append("distinct ");
        }
        builder.append(String.join((CharSequence)", ", fieldList)).append(" from `").append(this.tableName).append("`");
        for (TableColumnReference column : columns) {
            ForeignKeyReference foreignKey = (ForeignKeyReference)column;
            builder.append(' ').append(foreignKey.getJoinType().getSqlKeyword()).append(" join `").append(foreignKey.getForeignKeyTableName()).append("` ").append(foreignKey.getForeignKeyAlias()).append(" on `").append(foreignKey.getAlias()).append("`.`").append(foreignKey.getForeignKeyColumnName()).append("` = `").append(foreignKey.getForeignKeyAlias()).append("`.`id`");
        }
        builder.append(this.buildQueryClauses(queryParameters));
        return builder.toString();
    }

    abstract String buildQueryClauses(QueryParameters<E> var1);
}

