/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.queries.ordering;

import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.queries.ordering.OrderByStatement;
import com.github.collinalpert.java2db.queries.ordering.OrderTypes;
import com.github.collinalpert.lambda2sql.Lambda2Sql;
import com.github.collinalpert.lambda2sql.functions.SqlFunction;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringJoiner;

public class OrderByClause<E extends BaseEntity> {
    private final List<OrderByStatement<E>> orderByStatements;

    public OrderByClause(SqlFunction<E, ?> column, OrderTypes orderType) {
        this.orderByStatements = new LinkedList<OrderByStatement<OrderByStatement<E>>>(Collections.singletonList(new OrderByStatement<E>(Collections.singletonList(column), orderType)));
    }

    public OrderByClause(List<SqlFunction<E, ?>> columns, OrderTypes orderType) {
        this.orderByStatements = new LinkedList<OrderByStatement<OrderByStatement<E>>>(Collections.singletonList(new OrderByStatement<E>(columns, orderType)));
    }

    public void addStatement(SqlFunction<E, ?> column, OrderTypes orderType) {
        this.orderByStatements.add(new OrderByStatement<E>(Collections.singletonList(column), orderType));
    }

    public void addStatement(List<SqlFunction<E, ?>> columns, OrderTypes orderType) {
        this.orderByStatements.add(new OrderByStatement<E>(columns, orderType));
    }

    public String buildSql(String tableName) {
        StringJoiner orderByJoiner = new StringJoiner(", ", "order by ", "");
        StringBuilder builder = new StringBuilder();
        for (OrderByStatement<E> statement : this.orderByStatements) {
            if (statement.getColumns().size() == 1) {
                builder.append(Lambda2Sql.toSql(statement.getColumns().get(0), tableName));
            } else {
                StringJoiner coalesceJoiner = new StringJoiner(", ", "coalesce(", ")");
                for (SqlFunction<E, ?> orderByFunction : statement.getColumns()) {
                    coalesceJoiner.add(Lambda2Sql.toSql(orderByFunction, tableName));
                }
                builder.append(coalesceJoiner.toString());
            }
            builder.append(' ').append(statement.getOrderType().getSqlKeyword());
            orderByJoiner.add(builder);
            builder.setLength(0);
        }
        return orderByJoiner.toString();
    }
}

