/*
 * Decompiled with CFR 0.152.
 */
package com.trigersoft.jaque.expression;

import com.trigersoft.jaque.expression.ConstantExpression;
import com.trigersoft.jaque.expression.Expression;
import com.trigersoft.jaque.expression.ExpressionMethodVisitor;
import com.trigersoft.jaque.expression.ParameterExpression;
import java.util.function.Supplier;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

final class ExpressionClassVisitor
extends ClassVisitor {
    private final ClassLoader _loader;
    private final Supplier<ConstantExpression> _me;
    private final String _method;
    private final String _methodDesc;
    private Expression _result;
    private Class<?> _type;
    private Class<?>[] _argTypes;
    private Type _objectType;

    Expression getResult() {
        return this._result;
    }

    void setResult(Expression result) {
        this._result = result;
    }

    Class<?> getType() {
        return this._type;
    }

    ParameterExpression[] getParams() {
        ParameterExpression[] params = new ParameterExpression[this._argTypes.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = Expression.parameter(this._argTypes[i], i);
        }
        return params;
    }

    public ExpressionClassVisitor(ClassLoader loader, Supplier<ConstantExpression> instance, String method, String methodDescriptor) {
        super(458752);
        this._loader = loader;
        this._me = instance;
        this._method = method;
        this._methodDesc = methodDescriptor;
    }

    ClassLoader getLoader() {
        return this._loader;
    }

    Class<?> getClass(Type t) {
        try {
            switch (t.getSort()) {
                case 1: {
                    return Boolean.TYPE;
                }
                case 2: {
                    return Character.TYPE;
                }
                case 3: {
                    return Byte.TYPE;
                }
                case 4: {
                    return Short.TYPE;
                }
                case 5: {
                    return Integer.TYPE;
                }
                case 6: {
                    return Float.TYPE;
                }
                case 7: {
                    return Long.TYPE;
                }
                case 8: {
                    return Double.TYPE;
                }
                case 0: {
                    return Void.TYPE;
                }
            }
            String cn = t.getInternalName();
            cn = cn != null ? cn.replace('/', '.') : t.getClassName();
            return Class.forName(cn, false, this._loader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (!this._method.equals(name) || !this._methodDesc.equals(desc)) {
            return null;
        }
        Type ret = Type.getReturnType(desc);
        if (ret.getSort() == 0) {
            throw ExpressionMethodVisitor.notLambda(177);
        }
        this._type = this.getClass(ret);
        Type[] args = Type.getArgumentTypes(desc);
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = this.getClass(args[i]);
        }
        if (this._objectType != null && (access & 0x1000) == 0) {
            try {
                Class<?> implClass = this.getClass(this._objectType);
                this._result = Expression.invoke((Expression)Expression.parameter(implClass, 0), name, argTypes, new Expression[0]);
                this._argTypes = new Class[argTypes.length + 1];
                this._argTypes[0] = implClass;
                System.arraycopy(argTypes, 0, this._argTypes, 1, argTypes.length);
                return null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this._argTypes = argTypes;
        return new ExpressionMethodVisitor(this, (access & 8) == 0 ? this._me : null, argTypes);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if ((access & 0x1000) == 0) {
            this._objectType = Type.getObjectType(name);
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }
}

