/*
 * Decompiled with CFR 0.152.
 */
package com.github.containersolutions.operator.sample;

import com.github.containersolutions.operator.Context;
import com.github.containersolutions.operator.api.Controller;
import com.github.containersolutions.operator.api.ResourceController;
import com.github.containersolutions.operator.sample.CustomService;
import com.github.containersolutions.operator.sample.CustomServiceDoneable;
import com.github.containersolutions.operator.sample.CustomServiceList;
import io.fabric8.kubernetes.api.model.DoneableService;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import java.util.Arrays;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Controller(customResourceClass=CustomService.class, crdName="customservices.sample.javaoperatorsdk", kind="CustomService", group="sample.javaoperatorsdk", customResourceListClass=CustomServiceList.class, customResourceDonebaleClass=CustomServiceDoneable.class)
public class CustomServiceController
implements ResourceController<CustomService> {
    public static final String KIND = "CustomService";
    private static final Logger log = LoggerFactory.getLogger(CustomServiceController.class);
    public static final String GROUP = "sample.javaoperatorsdk";

    public boolean deleteResource(CustomService resource, Context<CustomService> context) {
        log.info("Execution deleteResource for: {}", (Object)resource.getMetadata().getName());
        ((ServiceResource)((NonNamespaceOperation)context.getK8sClient().services().inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).delete();
        return true;
    }

    public Optional<CustomService> createOrUpdateResource(CustomService resource, Context<CustomService> context) {
        log.info("Execution createOrUpdateResource for: {}", (Object)resource.getMetadata().getName());
        ServicePort servicePort = new ServicePort();
        servicePort.setPort(Integer.valueOf(8080));
        ServiceSpec serviceSpec = new ServiceSpec();
        serviceSpec.setPorts(Arrays.asList(servicePort));
        ((DoneableService)((DoneableService)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((DoneableService)((NonNamespaceOperation)context.getK8sClient().services().inNamespace(resource.getMetadata().getNamespace())).createOrReplaceWithNew()).withNewMetadata().withName(resource.getSpec().getName())).addToLabels("testLabel", resource.getSpec().getLabel())).endMetadata()).withSpec(serviceSpec)).done();
        return Optional.of(resource);
    }
}

