/*
 * Decompiled with CFR 0.152.
 */
package configuration;

import configuration.ClassContainerAdjuster;
import configuration.ClassProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import templateInput.TemplateInputParameters;

public class JavaForgerConfiguration {
    private String template;
    private TemplateInputParameters inputParameters;
    private ClassProvider inputClassProvider = new ClassProvider();
    private ClassProvider mergeClassProvider;
    private boolean merge = true;
    private final List<JavaForgerConfiguration> childConfigs = new ArrayList<JavaForgerConfiguration>();
    private final List<ClassContainerAdjuster> adjusters = new ArrayList<ClassContainerAdjuster>();
    private boolean createFileIfNotExists;
    private JavaForgerConfiguration configIfFileDoesNotExist;
    private boolean override = false;

    public JavaForgerConfiguration() {
    }

    private JavaForgerConfiguration(Builder builder) {
        this();
        this.template = builder.template;
        this.inputParameters = new TemplateInputParameters(builder.inputParameters);
        this.mergeClassProvider = builder.mergeClassProvider;
        this.inputClassProvider = builder.inputClassProvider == null ? this.inputClassProvider : builder.inputClassProvider;
        this.childConfigs.addAll(builder.childConfigs);
        this.adjusters.addAll(builder.adjusters);
        this.createFileIfNotExists = builder.createFileIfNotExists;
        this.configIfFileDoesNotExist = builder.configIfFileDoesNotExist;
        this.override = builder.override == null ? this.override : builder.override;
    }

    public boolean isMerge() {
        return this.merge;
    }

    public ClassProvider getInputClassProvider() {
        return this.inputClassProvider;
    }

    public void setInputClassProvider(ClassProvider inputClassProvider) {
        this.inputClassProvider = inputClassProvider;
    }

    public void setMerge(boolean merge) {
        this.merge = merge;
    }

    public ClassProvider getMergeClassProvider() {
        return this.mergeClassProvider;
    }

    public void setMergeClassProvider(ClassProvider mergeClassProvider) {
        this.mergeClassProvider = mergeClassProvider;
    }

    public void setMergeClass(String mergeClass) {
        this.mergeClassProvider = mergeClass == null ? null : new ClassProvider(mergeClass);
    }

    public List<JavaForgerConfiguration> getChildConfigs() {
        return this.childConfigs;
    }

    public void setChildConfigs(List<JavaForgerConfiguration> configs) {
        this.childConfigs.clear();
        this.childConfigs.addAll(configs);
    }

    public void addChildConfig(JavaForgerConfiguration config) {
        this.childConfigs.add(config);
    }

    public void addChildConfigs(JavaForgerConfiguration ... children) {
        this.childConfigs.addAll(Arrays.asList(children));
    }

    public String getTemplate() {
        return this.template;
    }

    public String getTemplateName() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public TemplateInputParameters getInputParameters() {
        return this.inputParameters.copy();
    }

    public void setInputParameters(TemplateInputParameters inputParameters) {
        this.inputParameters = inputParameters;
    }

    public void addInputParameter(String name, Object value) {
        this.inputParameters.put(name, value);
    }

    public ClassContainerAdjuster getAdjuster() {
        return parameters -> this.adjusters.stream().forEach(adj -> adj.accept(parameters));
    }

    public void addParameterAdjusters(ClassContainerAdjuster ... adjusters) {
        this.adjusters.addAll(Arrays.asList(adjusters));
    }

    public void setParameterAdjusters(ClassContainerAdjuster ... adjusters) {
        this.adjusters.clear();
        this.adjusters.addAll(Arrays.asList(adjusters));
    }

    public boolean isCreateFileIfNotExists() {
        return this.createFileIfNotExists;
    }

    public void setCreateFileIfNotExists(boolean createFileIfNotExists) {
        this.createFileIfNotExists = createFileIfNotExists;
    }

    public JavaForgerConfiguration getConfigIfFileDoesNotExist() {
        return this.configIfFileDoesNotExist;
    }

    public void setConfigIfFileDoesNotExist(JavaForgerConfiguration configIfFileDoesNotExist) {
        this.setCreateFileIfNotExists(true);
        this.configIfFileDoesNotExist = configIfFileDoesNotExist;
    }

    public void setOverride(boolean override) {
        this.override = override;
    }

    public boolean isOverride() {
        return this.override;
    }

    public void setRecursive(Consumer<JavaForgerConfiguration> consumer) {
        consumer.accept(this);
        this.childConfigs.stream().forEach(config -> config.setRecursive(consumer::accept));
    }

    public <T> void setRecursive(BiConsumer<JavaForgerConfiguration, T> setter, T value) {
        setter.accept(this, (JavaForgerConfiguration)value);
        this.childConfigs.stream().forEach(config -> config.setRecursive(setter, value));
    }

    public String toString() {
        return "config: " + this.template;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(JavaForgerConfiguration config) {
        return new Builder(config);
    }

    /* synthetic */ JavaForgerConfiguration(Builder builder, JavaForgerConfiguration javaForgerConfiguration) {
        this(builder);
    }

    public static final class Builder {
        private String template;
        private TemplateInputParameters inputParameters = new TemplateInputParameters();
        private ClassProvider mergeClassProvider;
        private ClassProvider inputClassProvider;
        private List<JavaForgerConfiguration> childConfigs = new ArrayList<JavaForgerConfiguration>();
        private List<ClassContainerAdjuster> adjusters = new ArrayList<ClassContainerAdjuster>();
        private boolean createFileIfNotExists;
        private JavaForgerConfiguration configIfFileDoesNotExist;
        private Boolean override;

        private Builder() {
        }

        private Builder(JavaForgerConfiguration config) {
            this.template = config.template;
            this.inputParameters = new TemplateInputParameters(config.inputParameters);
            this.mergeClassProvider = config.mergeClassProvider;
            this.childConfigs = config.childConfigs.stream().map(JavaForgerConfiguration::builder).map(Builder::build).collect(Collectors.toList());
            this.adjusters = new ArrayList<ClassContainerAdjuster>(config.adjusters);
        }

        public Builder withTemplate(String template) {
            this.template = template;
            return this;
        }

        public Builder withInputParameters(TemplateInputParameters inputParameters) {
            this.inputParameters = inputParameters;
            return this;
        }

        public Builder withMergeClass(String mergeClass) {
            this.mergeClassProvider = new ClassProvider(mergeClass);
            return this;
        }

        public Builder withChildConfig(JavaForgerConfiguration ... configs) {
            this.childConfigs.clear();
            this.childConfigs.addAll(Arrays.asList(configs));
            return this;
        }

        public JavaForgerConfiguration build() {
            return new JavaForgerConfiguration(this, null);
        }

        public Builder withParameterAdjusters(ClassContainerAdjuster ... adjusters) {
            this.adjusters.clear();
            this.adjusters.addAll(Arrays.asList(adjusters));
            return this;
        }

        public Builder withMergeClassProvider(ClassProvider mergeClassProvider) {
            this.mergeClassProvider = mergeClassProvider;
            return this;
        }

        public Builder withCreateFileIfNotExists(boolean createFileIfNotExists) {
            this.createFileIfNotExists = createFileIfNotExists;
            return this;
        }

        public Builder withInputClassProvider(ClassProvider classProvider) {
            this.inputClassProvider = classProvider;
            return this;
        }

        public Builder withConfigIfFileDoesNotExist(JavaForgerConfiguration configIfFileDoesNotExist) {
            this.createFileIfNotExists = true;
            this.configIfFileDoesNotExist = configIfFileDoesNotExist;
            return this;
        }

        public Builder withOverride(boolean override) {
            this.override = override;
            return this;
        }
    }
}

