/*
 * Decompiled with CFR 0.152.
 */
package templateInput.definition;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import templateInput.StringConverter;
import templateInput.definition.TypeDefinition;

public class ClassDefinition
extends TypeDefinition {
    private String extend;
    private List<String> interfaces;

    public ClassDefinition() {
    }

    protected ClassDefinition(Builder builder) {
        this.name = builder.name;
        this.type = new StringConverter(builder.type);
        this.lineNumber = builder.lineNumber;
        this.column = builder.column;
        this.annotations = builder.annotations;
        this.accessModifiers = builder.accessModifiers;
        this.extend = builder.extend;
        this.interfaces = builder.interfaces;
    }

    public String getExtend() {
        return this.extend;
    }

    public void setExtend(String extend) {
        this.extend = extend;
    }

    public List<String> getInterfaces() {
        return this.interfaces;
    }

    public void setInterfaces(List<String> interfaces) {
        this.interfaces = interfaces;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("extend", (Object)this.extend).append("interfaces", this.interfaces).build();
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals = false;
        if (this == obj) {
            equals = true;
        } else if (obj != null && this.getClass() == obj.getClass()) {
            ClassDefinition other = (ClassDefinition)obj;
            equals = new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.extend, (Object)other.extend).append(this.interfaces, other.interfaces).isEquals();
        }
        return equals;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ClassDefinition copy) {
        return new Builder(copy);
    }

    public static final class Builder {
        private StringConverter name;
        private String type;
        private int lineNumber;
        private int column;
        private Set<String> annotations = new HashSet<String>();
        private Set<String> accessModifiers = new HashSet<String>();
        private String extend;
        public List<String> interfaces;

        private Builder() {
        }

        private Builder(ClassDefinition copy) {
            this.name = copy.name;
            this.type = copy.type.toString();
            this.lineNumber = copy.lineNumber;
            this.column = copy.column;
            this.annotations = copy.annotations;
            this.accessModifiers = copy.accessModifiers;
            this.extend = copy.extend;
            this.interfaces = copy.interfaces;
        }

        public Builder withName(String name) {
            this.name = new StringConverter(name);
            return this;
        }

        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Builder withLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
            return this;
        }

        public Builder withColumn(int column) {
            this.column = column;
            return this;
        }

        public Builder withAnnotations(Set<String> annotations) {
            this.annotations = annotations;
            return this;
        }

        public Builder withAccessModifiers(Set<String> accessModifiers) {
            this.accessModifiers = accessModifiers;
            return this;
        }

        public Builder withInterfaces(List<String> interfaces) {
            this.interfaces = interfaces;
            return this;
        }

        public Builder withExtend(String extend) {
            this.extend = extend;
            return this;
        }

        public ClassDefinition build() {
            return new ClassDefinition(this);
        }
    }
}

