/*
 * Decompiled with CFR 0.152.
 */
package templateInput.definition;

import initialization.InitDefaultValues;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import templateInput.StringConverter;

public class TypeDefinition
implements Comparable<TypeDefinition> {
    protected StringConverter name;
    protected StringConverter type;
    protected LinkedHashSet<String> typeImports = new LinkedHashSet();
    protected int lineNumber;
    protected int column;
    protected Set<String> annotations = new HashSet<String>();
    protected Set<String> accessModifiers = new HashSet<String>();

    public TypeDefinition() {
    }

    public TypeDefinition(TypeDefinition type) {
        this.name = type.name;
        this.type = type.type;
        this.lineNumber = type.lineNumber;
        this.column = type.column;
        this.annotations = type.annotations;
        this.accessModifiers = type.accessModifiers;
    }

    @Override
    public int compareTo(TypeDefinition o) {
        int line = this.getLineNumber() - o.getLineNumber();
        int column = this.getColumn() - o.getColumn();
        return line != 0 ? line : column;
    }

    public StringConverter getName() {
        return this.name;
    }

    public String getNameAsString() {
        return this.name.toString();
    }

    public void setName(String name) {
        this.name = new StringConverter(name);
    }

    public StringConverter getType() {
        return this.type;
    }

    public String getNonPrimitiveType() {
        return InitDefaultValues.getObjectForPrimitive(this.type.toString());
    }

    public boolean isPrimitive() {
        return InitDefaultValues.isPrimitive(this.type.toString());
    }

    public void setType(String type) {
        this.type = new StringConverter(type);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public Set<String> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Set<String> annotations) {
        this.annotations = annotations;
    }

    public Set<String> getAccessModifiers() {
        return this.accessModifiers;
    }

    public void setAccessModifiers(Set<String> accessModifiers) {
        this.accessModifiers = accessModifiers;
    }

    public LinkedHashSet<String> getTypeImports() {
        return this.typeImports;
    }

    public void addTypeImport(String typeImport) {
        this.typeImports.add(typeImport);
    }

    public void addTypeImports(List<String> imports) {
        this.typeImports.addAll(imports);
    }

    public void addTypeImports(LinkedHashSet<String> imports) {
        this.typeImports.addAll(imports);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.annotations, this.lineNumber, this.column);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("name", (Object)this.name).append("type", (Object)this.type).append("annotations", this.annotations).append("lineNumber", this.lineNumber).append("column", this.column).append("accessModifiers", this.accessModifiers).append("typeImports", this.typeImports).build();
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (this == obj) {
            equals = true;
        } else if (obj != null && this.getClass() == obj.getClass()) {
            TypeDefinition other = (TypeDefinition)obj;
            equals = new EqualsBuilder().append((Object)this.name, (Object)other.name).append((Object)this.type, (Object)other.type).append(this.lineNumber, other.lineNumber).append(this.column, other.column).append(this.annotations, other.annotations).append(this.accessModifiers, other.accessModifiers).append(this.typeImports, other.typeImports).isEquals();
        }
        return equals;
    }
}

