/*
 * Decompiled with CFR 0.152.
 */
package merger;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ParseStart;
import com.github.javaparser.Provider;
import com.github.javaparser.Providers;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.printer.lexicalpreservation.LexicalPreservingPrinter;
import configuration.PathConverter;
import generator.CodeSnipit;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import reader.Parser;

public class CodeSnipitReader {
    public CompilationUnit read(CodeSnipit codeSnipit, String classPath) {
        CompilationUnit n;
        if (this.hasClassCodeDefined(codeSnipit)) {
            String completeClass = this.toCompleteClass(codeSnipit, classPath);
            n = this.readClass(completeClass);
        } else {
            CompilationUnit cu = new CompilationUnit();
            String string = codeSnipit.toString();
            int lineBegin = this.getFirstIndexAfterComment(string);
            int lineEnd = lineBegin + string.substring(lineBegin).indexOf(";");
            lineEnd = lineEnd < 0 ? string.length() : lineEnd + 1;
            String declaration = string.substring(lineBegin, lineEnd);
            boolean endOfFile = false;
            ParseResult<PackageDeclaration> pack = this.parsePackage(declaration);
            if (pack.isSuccessful()) {
                cu.setPackageDeclaration((PackageDeclaration)pack.getResult().get());
                boolean bl = endOfFile = lineEnd == string.length();
                if (!endOfFile) {
                    lineBegin = lineEnd + 1;
                    lineEnd = (lineEnd = lineBegin + string.substring(lineBegin).indexOf(";")) < 0 ? string.length() : lineEnd + 1;
                    declaration = string.substring(lineBegin, lineEnd);
                }
            }
            declaration = string.substring(lineBegin, lineEnd);
            ParseResult<ImportDeclaration> result = this.parseImport(declaration);
            while (result.isSuccessful() && !endOfFile) {
                cu.addImport((ImportDeclaration)result.getResult().get());
                endOfFile = lineEnd == string.length();
                if (endOfFile) continue;
                lineBegin = lineEnd + 1;
                lineEnd = (lineEnd = lineBegin + string.substring(lineBegin).indexOf(";")) < 0 ? string.length() : lineEnd + 1;
                declaration = string.substring(lineBegin, lineEnd);
                result = this.parseImport(declaration);
            }
            n = cu;
        }
        return n;
    }

    public String toCompleteClass(CodeSnipit codeSnipit, String mergeClassPath) {
        String string = codeSnipit.toString();
        int index = this.firstIndexAfterImports(string);
        StringBuilder code = new StringBuilder();
        code.append(string.substring(0, index));
        boolean hasClassDefined = this.hasClassDefined(string.substring(index));
        if (!hasClassDefined) {
            code.append("public class " + PathConverter.toClassName(mergeClassPath) + " {");
        }
        code.append(string.substring(index));
        if (!hasClassDefined) {
            code.append("\n}");
        }
        return code.toString();
    }

    private boolean hasClassCodeDefined(CodeSnipit codeSnipit) {
        int index;
        String string = codeSnipit.toString();
        String codeAfterImports = string.substring(index = this.firstIndexAfterImports(string));
        return this.hasClassDefined(codeAfterImports) || codeAfterImports.contains(";");
    }

    protected CompilationUnit readClass(String completeClass) {
        CompilationUnit cu = Parser.parse(completeClass);
        LexicalPreservingPrinter.setup((Node)cu);
        return cu;
    }

    protected CompilationUnit read(String className) throws IOException {
        CompilationUnit cu = null;
        try (FileInputStream in = new FileInputStream(className);){
            cu = StaticJavaParser.parse((InputStream)in);
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        LexicalPreservingPrinter.setup(cu);
        return cu;
    }

    protected int firstIndexAfterImports(String string) {
        int lineBegin;
        int lineEnd = (lineBegin = this.getFirstIndexAfterComment(string)) + string.substring(lineBegin).indexOf(";");
        lineEnd = lineEnd < 0 ? string.length() : lineEnd + 1;
        String declaration = string.substring(lineBegin, lineEnd);
        ParseResult<PackageDeclaration> result = this.parsePackage(declaration);
        if (!result.isSuccessful()) {
            result = this.parseImport(declaration);
        }
        while (result.isSuccessful()) {
            if (lineEnd == string.length()) {
                lineBegin = lineEnd;
                break;
            }
            lineBegin = lineEnd + 1;
            lineEnd = (lineEnd = lineBegin + string.substring(lineBegin).indexOf(";")) < 0 ? string.length() : lineEnd + 1;
            declaration = string.substring(lineBegin, lineEnd);
            result = this.parseImport(declaration);
        }
        lineBegin = this.getIndexAfterNewLine(string, lineBegin);
        return lineBegin;
    }

    private int getIndexAfterNewLine(String string, int lineBegin) {
        int index = this.getIndexAfterNewLine(string, lineBegin, "\r");
        index = this.getIndexAfterNewLine(string, index, "\n");
        return index;
    }

    private int getIndexAfterNewLine(String string, int lineBegin, String newLineIndicator) {
        int newLine = string.substring(lineBegin).indexOf(newLineIndicator);
        int index = lineBegin;
        if (0 <= newLine && newLine < 3) {
            index = index + newLine + 1;
        }
        return index;
    }

    protected int getFirstIndexAfterComment(String string) {
        int index = 0;
        if (string.startsWith("/*")) {
            index = string.indexOf("*/") + 3;
        }
        return index;
    }

    protected ParseResult<PackageDeclaration> parsePackage(String declaration) {
        return this.parseDeclaration(declaration, ParseStart.PACKAGE_DECLARATION);
    }

    protected ParseResult<ImportDeclaration> parseImport(String declaration) {
        return this.parseDeclaration(declaration, ParseStart.IMPORT_DECLARATION);
    }

    protected boolean hasClassDefined(String string) {
        return this.parseDeclaration(string, ParseStart.COMPILATION_UNIT).isSuccessful();
    }

    private <N extends Node> ParseResult<N> parseDeclaration(String declaration, ParseStart<N> parseStart) {
        JavaParser parser = new JavaParser();
        Provider provider = Providers.provider((String)declaration);
        ParseResult result = parser.parse(parseStart, provider);
        return result;
    }
}

