/*
 * Decompiled with CFR 0.152.
 */
package reader;

import com.github.javaparser.ast.type.Type;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import configuration.StaticJavaForgerConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import templateInput.definition.TypeDefinition;

public class ImportResolver {
    private static final Logger LOG = LoggerFactory.getLogger(ImportResolver.class);
    private StaticJavaForgerConfiguration staticConfig = StaticJavaForgerConfiguration.getConfig();

    @Deprecated
    public void resolveAndSetImport(Type type, TypeDefinition variable) {
        this.resolveImport(type).forEach(variable::addTypeImport);
    }

    public List<String> resolveImport(Type type) {
        List<String> imports = this.resolve(type);
        return !imports.isEmpty() ? imports.stream().filter(s -> !s.contains("?")).collect(Collectors.toList()) : Collections.emptyList();
    }

    private List<String> resolve(Type type) {
        ArrayList<String> imports = new ArrayList<String>();
        if (this.staticConfig.getSymbolSolver() != null) {
            try {
                ResolvedType resolve = type.resolve();
                imports.addAll(this.getImportsFromResolvedType(resolve));
            }
            catch (Exception e) {
                LOG.error("Could not resolve import for {}, check if symbol server is correctly setup using StaticJavaForgerConfiguration::setProjectPaths. Received exception with message: {}", (Object)type.asString(), (Object)e.getMessage());
            }
        }
        return imports;
    }

    private List<String> getImportsFromResolvedType(ResolvedType resolve) {
        String imp;
        ArrayList<String> imports = new ArrayList<String>();
        if (resolve.isReferenceType()) {
            ResolvedReferenceType refType = resolve.asReferenceType();
            ResolvedReferenceTypeDeclaration type = refType.getTypeDeclaration();
            imp = type.getQualifiedName();
            List innerResolvedTypes = type.getTypeParameters().stream().map(tp -> refType.typeParametersMap().getValue(tp)).collect(Collectors.toList());
            List collect = innerResolvedTypes.stream().flatMap(t -> this.getImportsFromResolvedType((ResolvedType)t).stream()).collect(Collectors.toList());
            imports.addAll(collect);
        } else {
            imp = resolve.describe();
        }
        if (!imp.startsWith("java.lang.") && !resolve.isPrimitive()) {
            imports.add(imp);
        }
        return imports;
    }
}

