/*
 * Decompiled with CFR 0.152.
 */
package generator;

import configuration.JavaForgerConfiguration;
import configuration.PathConverter;
import configuration.StaticJavaForgerConfiguration;
import initialization.InitializationService;
import java.io.IOException;
import reader.ClassContainerReader;
import templateInput.ClassContainer;
import templateInput.TemplateInputDefaults;
import templateInput.TemplateInputParameters;

public class TemplateInputParametersService {
    private ClassContainerReader reader = StaticJavaForgerConfiguration.getReader();
    private InitializationService initializer = StaticJavaForgerConfiguration.getInitializer();

    public TemplateInputParameters getInputParameters(JavaForgerConfiguration config, String inputClass, String mergeClassPath) throws IOException {
        TemplateInputParameters inputParameters = config.getInputParameters();
        if (!(inputClass == null || inputClass.isEmpty() || inputParameters.containsKey(TemplateInputDefaults.FIELDS.getName()) && inputParameters.containsKey(TemplateInputDefaults.CLASS.getName()) && inputParameters.containsKey(TemplateInputDefaults.METHODS.getName()) && inputParameters.containsKey(TemplateInputDefaults.CONSTRUCTORS.getName()))) {
            ClassContainer claz = this.reader.read(inputClass);
            this.initializer.init(claz);
            config.getAdjuster().accept(claz);
            if (!inputParameters.containsKey(TemplateInputDefaults.FIELDS.getName())) {
                inputParameters.put(TemplateInputDefaults.FIELDS.getName(), claz.getFields());
            }
            if (!inputParameters.containsKey(TemplateInputDefaults.CLASS.getName())) {
                inputParameters.put(TemplateInputDefaults.CLASS.getName(), claz);
            }
            if (!inputParameters.containsKey(TemplateInputDefaults.METHODS.getName())) {
                inputParameters.put(TemplateInputDefaults.METHODS.getName(), claz.getMethods());
            }
            if (!inputParameters.containsKey(TemplateInputDefaults.CONSTRUCTORS.getName())) {
                inputParameters.put(TemplateInputDefaults.CONSTRUCTORS.getName(), claz.getConstructors());
            }
        }
        if (mergeClassPath != null) {
            if (!inputParameters.containsKey(TemplateInputDefaults.PACKAGE.getName())) {
                String pack = PathConverter.toPackage(mergeClassPath);
                inputParameters.put(TemplateInputDefaults.PACKAGE.getName(), pack);
            }
            if (!inputParameters.containsKey(TemplateInputDefaults.MERGE_CLASS_NAME.getName())) {
                String a = mergeClassPath.replace("\\", "/");
                String name = a.substring(a.lastIndexOf("/") + 1, a.lastIndexOf("."));
                inputParameters.put(TemplateInputDefaults.MERGE_CLASS_NAME.getName(), name);
            }
        }
        return inputParameters;
    }
}

