/*
 * Decompiled with CFR 0.152.
 */
package com.java_podio.code_gen;

import com.google.common.base.CaseFormat;
import com.java_podio.code_gen.CodeGenerator;
import com.java_podio.code_gen.EnumGenerator;
import com.java_podio.code_gen.JMember;
import com.java_podio.code_gen.JavaNames;
import com.java_podio.code_gen.PodioType;
import com.java_podio.code_gen.static_classes.AppWrapper;
import com.java_podio.code_gen.static_classes.PodioCurrency;
import com.java_podio.code_gen.static_classes.PodioDate;
import com.podio.app.Application;
import com.podio.app.ApplicationField;
import com.podio.app.ApplicationFieldStatus;
import com.podio.contact.Profile;
import com.podio.embed.Embed;
import com.podio.item.FieldValuesUpdate;
import com.podio.item.FieldValuesView;
import com.podio.item.Item;
import com.podio.item.ItemCreate;
import com.sun.codemodel.JCase;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JForEach;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JSwitch;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.text.ParseException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AppGenerator {
    private static final String FIELD_IS_OF_UNSUPPORTET_TYPE_JAVADOC = "Field is of unsupported type and is not parsed, hence always {@code null}!";
    private static final Logger LOGGER = Logger.getLogger(AppGenerator.class.getName());
    protected JCodeModel jCodeModel;
    JMethod constructorFromItem;
    JMethod _setValue;
    private JMethod _getItemCreate;
    private JVar _itemCreateFieldValues;
    private EnumGenerator enumGenerator;
    protected JPackage jp;
    private JDefinedClass jc = null;
    private JForEach setValuesFromItemForEachField;
    private JSwitch setValuesFromItemSwitch;
    private JVar itemCreateResult;

    public AppGenerator(JCodeModel jCodeModel, JPackage jPackage) throws JClassAlreadyExistsException {
        this.jCodeModel = jCodeModel;
        this.jp = jPackage;
    }

    public JDefinedClass getAppClass(Application app) throws JClassAlreadyExistsException {
        String className = JavaNames.createValidJavaTypeName(app.getConfiguration().getName(), this.jp.name());
        this.jc = this.jp._class(className)._extends(AppWrapper.class);
        this.jc.field(24, (JType)this.jCodeModel.LONG, "serialVersionUID", JExpr.lit((int)1));
        this.jc.field(25, (JType)this.jCodeModel.INT, "APP_ID", JExpr.lit((int)app.getId()));
        this._setValue = null;
        this._setValue = this._setValue();
        this._getItemCreate = null;
        this._getItemCreate = this._getItemCreate();
        this.enumGenerator = new EnumGenerator(this.jCodeModel, this.jp.subPackage(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, className)));
        JDocComment jDocComment = this.jc.javadoc();
        jDocComment.add((Object)("Wrapper for podio app '" + app.getConfiguration().getName() + "' (id=" + app.getId() + ").\nGenerated by java-podio-code-gen."));
        this.jc.method(1, Integer.class, "getAppId").body()._return(JExpr.lit((int)app.getId()));
        this.jc.method(1, String.class, "getAppExternalId").body()._return(JExpr.lit((String)(app.getConfiguration().getExternalId() == null ? "" : app.getConfiguration().getExternalId())));
        this.jc.constructor(1);
        this.constructorFromItem = this.jc.constructor(1);
        JVar constructorFromItemParam = this.constructorFromItem.param(Item.class, CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, className) + "Item");
        this.constructorFromItem._throws(ParseException.class);
        this.constructorFromItem.body().invoke(this._setValue()).arg((JExpression)constructorFromItemParam);
        for (ApplicationField f : app.getFields()) {
            String name = CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, f.getExternalId().toLowerCase());
            PodioType type = PodioType.forApplicationField(f);
            String javadoc = f.getConfiguration().getDescription();
            javadoc = this.attachTypeSpecificJavadoc(type, javadoc);
            JClass javaType = this.getType(type, f);
            JMember field = CodeGenerator.addMember(this.jc, name, (JType)javaType, javadoc, this.jCodeModel, ApplicationFieldStatus.DELETED.equals((Object)f.getStatus()));
            this.jc.field(25, (JType)this.jCodeModel.INT, "FIELD_ID_" + CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, name), JExpr.lit((int)f.getId()));
            JCase jcase = this.setValuesFromItemSwitch._case(JExpr.lit((int)f.getId()));
            jcase.body().invoke(field.getSetter()).arg(this.createGetFieldValue(type, this.setValuesFromItemForEachField.var(), javaType));
            jcase.body()._break();
            JExpression fieldValueUpdate = this.createFieldValuesUpdate(field.getGetter(), type, f);
            if (fieldValueUpdate == null) continue;
            JConditional cond = this._getItemCreate().body()._if(JExpr.invoke((JMethod)field.getGetter()).ne(JExpr._null()));
            cond._then().add((JStatement)this._itemCreateFieldValues.invoke("add").arg(fieldValueUpdate));
        }
        this._getItemCreate().body()._return((JExpression)this.itemCreateResult);
        CodeGenerator.addToString(this.jc, this.jCodeModel, true);
        CodeGenerator.addEquals(this.jc, this.jCodeModel, true);
        return this.jc;
    }

    private String attachTypeSpecificJavadoc(PodioType type, String javadoc) {
        if (type.equals((Object)PodioType.UNDEFINED)) {
            javadoc = javadoc == null ? FIELD_IS_OF_UNSUPPORTET_TYPE_JAVADOC : (String)javadoc + "\nField is of unsupported type and is not parsed, hence always {@code null}!";
        } else if (type.equals((Object)PodioType.DURATION)) {
            javadoc = javadoc == null ? "Duration in seconds." : (String)javadoc + "\nDuration in seconds.";
        } else if (type.equals((Object)PodioType.PROGRESS)) {
            javadoc = javadoc == null ? "Progress: 0=min, 100=max." : (String)javadoc + "\nProgress: 0=min, 100=max.";
        } else if (type.equals((Object)PodioType.CONTACT)) {
            javadoc = javadoc == null ? "For updates/create only {@code profileId} is relevant." : (String)javadoc + "\nFor updates/create only {@code profileId} is relevant";
        } else if (type.equals((Object)PodioType.EMBED)) {
            javadoc = javadoc == null ? "For updates/create only {@code id} is relevant (need to create embed beforehand!)." : (String)javadoc + "\nFor updates/create only {@code id} is relevant (need to create embed beforehand!).";
        }
        return javadoc;
    }

    public JMethod _setValue() throws JClassAlreadyExistsException {
        if (this._setValue != null) {
            return this._setValue;
        }
        this._setValue = this.jc.method(1, (JType)this.jCodeModel.VOID, "setValue");
        this._setValue._throws(ParseException.class);
        this._setValue.annotate(SuppressWarnings.class).param("value", "unchecked");
        JVar setValuesFromItemParam = this._setValue.param(Item.class, CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, "item"));
        this._setValue.body().add((JStatement)JExpr._super().invoke("setValue").arg((JExpression)setValuesFromItemParam));
        this.setValuesFromItemForEachField = this._setValue.body().forEach((JType)this.jCodeModel.ref(FieldValuesView.class), "field", (JExpression)setValuesFromItemParam.invoke("getFields"));
        this.setValuesFromItemSwitch = this.setValuesFromItemForEachField.body()._switch((JExpression)this.setValuesFromItemForEachField.var().invoke("getId"));
        this.setValuesFromItemSwitch._default().body().directStatement("System.out.println(\"ERROR: unexpected field id=\"+field.getId() (App: \"+this.getClass().getName()+\"");
        this.setValuesFromItemSwitch._default().body()._break();
        return this._setValue;
    }

    public JMethod _getItemCreate() {
        if (this._getItemCreate != null) {
            return this._getItemCreate;
        }
        this._getItemCreate = this.jc.method(1, this.jCodeModel._ref(ItemCreate.class), "getItemCreate");
        this.itemCreateResult = this._getItemCreate.body().decl((JType)this.jCodeModel.ref(ItemCreate.class), "result", (JExpression)JExpr._super().invoke("getItemCreate"));
        this._itemCreateFieldValues = this._getItemCreate.body().decl((JType)this.jCodeModel.ref(List.class).narrow(FieldValuesUpdate.class), "fieldValuesList", (JExpression)this.itemCreateResult.invoke("getFields"));
        return this._getItemCreate;
    }

    private JClass getType(PodioType type, ApplicationField f) {
        JClass result;
        switch (type) {
            case CATEGORY_MULTI: 
            case CATEGORY_SINGLE: {
                String name = JavaNames.createValidJavaTypeName(f.getExternalId(), this.jp.name());
                try {
                    result = this.enumGenerator.generateEnum(f, name);
                    if (!type.equals((Object)PodioType.CATEGORY_MULTI)) break;
                    result = this.jCodeModel.ref(List.class).narrow(result);
                }
                catch (JClassAlreadyExistsException e) {
                    LOGGER.log(Level.SEVERE, "ERROR: could not generate enum with name: " + name + "(might exist twice?!)", e);
                    result = this.jCodeModel.ref(Integer.class);
                }
                break;
            }
            case CONTACT: {
                result = this.jCodeModel.ref(List.class).narrow(Profile.class);
                break;
            }
            case APP: {
                result = this.jCodeModel.ref(List.class).narrow(Integer.class);
                break;
            }
            case EMBED: {
                result = this.jCodeModel.ref(List.class).narrow(Embed.class);
                break;
            }
            default: {
                result = this.jCodeModel.ref(type.getJavaType());
            }
        }
        return result;
    }

    private JExpression createFieldValuesUpdate(JMethod getter, PodioType type, ApplicationField f) throws JClassAlreadyExistsException {
        switch (type) {
            case TEXT: {
                return JExpr._new((JClass)this.jCodeModel.ref(FieldValuesUpdate.class)).arg(f.getExternalId()).arg("value").arg(JOp.cond((JExpression)JExpr.invoke((JMethod)getter).invoke("length").eq(JExpr.lit((int)0)), (JExpression)JExpr.lit((String)" "), (JExpression)JExpr.invoke((JMethod)getter)));
            }
            case NUMBER: 
            case DURATION: 
            case PROGRESS: {
                return JExpr._new((JClass)this.jCodeModel.ref(FieldValuesUpdate.class)).arg(f.getExternalId()).arg("value").arg((JExpression)JExpr.invoke((JMethod)getter));
            }
            case DATE: 
            case MONEY: {
                return JExpr.invoke((JMethod)getter).invoke("getFieldValuesUpdate").arg(JExpr.lit((String)f.getExternalId()));
            }
            case CATEGORY_SINGLE: {
                return JExpr._new((JClass)this.jCodeModel.ref(FieldValuesUpdate.class)).arg(f.getExternalId()).arg("value").arg((JExpression)JExpr.invoke((JMethod)getter).invoke("getPodioId"));
            }
            case CATEGORY_MULTI: {
                return JExpr.invoke((String)"getFielddValuesUpdateFromMultiCategory").arg((JExpression)JExpr.invoke((JMethod)getter)).arg(f.getExternalId());
            }
            case CONTACT: {
                return JExpr.invoke((String)"getFieldValuesUpdateFromContacts").arg((JExpression)JExpr.invoke((JMethod)getter)).arg(f.getExternalId());
            }
            case EMBED: {
                return JExpr.invoke((String)"getFieldValuesUpdateFromEmbeds").arg((JExpression)JExpr.invoke((JMethod)getter)).arg(f.getExternalId());
            }
            case APP: {
                return JExpr.invoke((String)"getFieldValuesUpdateFromApp").arg((JExpression)JExpr.invoke((JMethod)getter)).arg(f.getExternalId());
            }
        }
        return null;
    }

    private JExpression createGetFieldValue(PodioType type, JVar jVar, JClass javaType) throws JClassAlreadyExistsException {
        switch (type) {
            case TEXT: {
                return AppGenerator.createGetStringFieldValue(jVar, "value", this.jCodeModel);
            }
            case NUMBER: {
                return this.createGetDoubleFieldValue(jVar);
            }
            case DURATION: 
            case PROGRESS: {
                return this.createGetIntegerFieldValue(jVar);
            }
            case MONEY: {
                return this.createGetCurrencyFieldValue(jVar);
            }
            case DATE: {
                return this.createGetDateFieldValue(jVar);
            }
            case CATEGORY_SINGLE: {
                JExpression podioId = JExpr.direct((String)("(Integer) ((java.util.Map<String, ?>) " + jVar.name() + ".getValues().get(0).get(\"value\")).get(\"id\")"));
                return javaType.staticInvoke("byId").arg(podioId);
            }
            case CATEGORY_MULTI: {
                return JExpr.invoke((String)"parseMultiCategoryField").arg((JExpression)jVar).arg(JExpr.dotclass((JClass)((JClass)javaType.getTypeParameters().get(0))));
            }
            case APP: {
                return JExpr.invoke((String)"parseAppField").arg((JExpression)jVar);
            }
            case CONTACT: {
                return JExpr.invoke((String)"parseFieldJson").arg((JExpression)jVar).arg(JExpr.dotclass((JClass)this.jCodeModel.ref(Profile.class))).arg("value");
            }
            case EMBED: {
                return JExpr.invoke((String)"parseFieldJson").arg((JExpression)jVar).arg(JExpr.dotclass((JClass)this.jCodeModel.ref(Embed.class))).arg("embed");
            }
        }
        LOGGER.warning("could not create getFieldValueExpression for type: " + type);
        return JExpr._null();
    }

    private JExpression createGetCurrencyFieldValue(JVar jVar) {
        return JExpr._new((JClass)this.jCodeModel.ref(PodioCurrency.class)).arg(this.createGetDoubleFieldValue(jVar)).arg(AppGenerator.createGetStringFieldValue(jVar, "currency", this.jCodeModel));
    }

    private JExpression createGetDateFieldValue(JVar jVar) throws JClassAlreadyExistsException {
        this._setValue()._throws(ParseException.class);
        this.constructorFromItem._throws(ParseException.class);
        JExpression start = AppGenerator.createGetStringFieldValue(jVar, "start", this.jCodeModel);
        JExpression end = AppGenerator.createGetStringFieldValue(jVar, "end", this.jCodeModel);
        return JExpr._new((JClass)this.jCodeModel.ref(PodioDate.class)).arg(start).arg(end);
    }

    public static JExpression createGetStringFieldValue(JVar jVar, String field, JCodeModel jCodeModel) {
        return JExpr.cast((JType)jCodeModel._ref(String.class), (JExpression)jVar.invoke("getValues").invoke("get").arg(JExpr.lit((int)0)).invoke("get").arg(field));
    }

    private JExpression createGetDoubleFieldValue(JVar jVar) {
        return this.jCodeModel.ref(Double.class).staticInvoke("parseDouble").arg(AppGenerator.createGetStringFieldValue(jVar, "value", this.jCodeModel));
    }

    private JExpression createGetIntegerFieldValue(JVar jVar) {
        return JExpr.cast((JType)this.jCodeModel._ref(Integer.class), (JExpression)jVar.invoke("getValues").invoke("get").arg(JExpr.lit((int)0)).invoke("get").arg("value"));
    }
}

