/*
 * Decompiled with CFR 0.152.
 */
package com.java_podio.code_gen;

import com.google.common.base.CaseFormat;
import com.java_podio.code_gen.AppGenerator;
import com.java_podio.code_gen.JMember;
import com.podio.app.Application;
import com.podio.app.ApplicationField;
import com.podio.app.CategoryOption;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.List;
import java.util.logging.Logger;

public class CodeGenerator {
    private static final Logger LOGGER = Logger.getLogger(CodeGenerator.class.getName());
    final JCodeModel jCodeModel = new JCodeModel();
    JFieldVar podioDateFormatter;
    private JPackage jBasePackage;
    private AppGenerator appGenerator;

    public CodeGenerator(String basePackage) {
        this.jBasePackage = this.jCodeModel._package(basePackage);
    }

    public JCodeModel generateCode(List<Application> appInfos) throws JClassAlreadyExistsException {
        for (Application application : appInfos) {
            CodeGenerator.printApp(application);
        }
        this.appGenerator = new AppGenerator(this.jCodeModel, this.jBasePackage);
        for (Application app : appInfos) {
            this.appGenerator.getAppClass(app);
        }
        return this.jCodeModel;
    }

    public static JMember addMember(JDefinedClass jc, String name, JType type, String javadoc, JCodeModel jCodeModel) {
        return CodeGenerator.addMember(jc, name, type, javadoc, jCodeModel, false);
    }

    public static JMember addMember(JDefinedClass jc, String name, JType type, String javadoc, JCodeModel jCodeModel, boolean isDeleted) {
        String nameLowerCamelCase = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, name);
        JFieldVar var = jc.field(2, type, nameLowerCamelCase);
        JMethod getter = jc.method(1, type, "get" + name);
        JBlock returnBlock = getter.body();
        returnBlock._return((JExpression)var);
        JMethod setter = jc.method(1, (JType)jCodeModel.VOID, "set" + name);
        JVar param = setter.param(type, nameLowerCamelCase);
        JBlock setterBlock = setter.body();
        setterBlock.assign((JAssignmentTarget)JExpr._this().ref((JVar)var), (JExpression)param);
        if (javadoc != null) {
            var.javadoc().add((Object)javadoc);
            getter.javadoc().add((Object)javadoc);
            setter.javadoc().add((Object)javadoc);
        }
        if (isDeleted) {
            var.annotate(Deprecated.class);
            var.javadoc().addDeprecated().add((Object)"This field is deleted in Podio!");
            getter.annotate(Deprecated.class);
            getter.javadoc().addDeprecated().add((Object)"This field is deleted in Podio!");
            setter.annotate(Deprecated.class);
            setter.javadoc().addDeprecated().add((Object)"This field is deleted in Podio!");
        }
        return new JMember(var, getter, setter);
    }

    public static void printApp(Application app) {
        LOGGER.info("AppId=" + app.getId());
        LOGGER.info("AppExternalId=" + app.getConfiguration().getExternalId());
        LOGGER.info("AppName=" + app.getConfiguration().getName());
        LOGGER.info("AppItemName=" + app.getConfiguration().getItemName());
        LOGGER.info("FIELDS:");
        for (ApplicationField appField : app.getFields()) {
            CodeGenerator.printAppField(appField);
            LOGGER.info("--");
        }
    }

    public static void printAppField(ApplicationField appField) {
        LOGGER.info("FieldId=" + appField.getId());
        LOGGER.info("FieldExternalId=" + appField.getExternalId());
        LOGGER.info("FieldDescription=" + appField.getConfiguration().getDescription());
        LOGGER.info("FieldLabel=" + appField.getConfiguration().getLabel());
        LOGGER.info("FieldIsRequired=" + appField.getConfiguration().isRequired());
        if (appField.getConfiguration().getSettings() != null) {
            LOGGER.info("FieldAllowedValues=" + appField.getConfiguration().getSettings().getAllowedValues());
            LOGGER.info("FieldAllowedCurrencies=" + appField.getConfiguration().getSettings().getAllowedCurrencies());
            LOGGER.info("FieldMultiple=" + appField.getConfiguration().getSettings().getMultiple());
            LOGGER.info("FieldReferenceableTypes=" + appField.getConfiguration().getSettings().getReferenceableTypes());
            if (appField.getConfiguration().getSettings().getOptions() != null) {
                for (CategoryOption option : appField.getConfiguration().getSettings().getOptions()) {
                    LOGGER.info("FieldOption: " + option.getId() + ", " + option.getText() + ", " + option.getStatus());
                }
            }
            LOGGER.info("FieldTextFieldSize=" + appField.getConfiguration().getSettings().getSize());
        }
        LOGGER.info("FieldType=" + appField.getType().toString());
    }

    public static void addToString(JDefinedClass jclass, JCodeModel jCodeModel, boolean includeSuperToString) {
        boolean first = true;
        JMethod toString = jclass.method(1, (JType)jCodeModel.ref(String.class), "toString");
        JVar result = toString.body().decl((JType)jCodeModel.ref(String.class), "result", JExpr.lit((String)(jclass.name() + " [")));
        if (includeSuperToString) {
            toString.body().assignPlus((JAssignmentTarget)result, (JExpression)JExpr._super().invoke("toString"));
            first = false;
        }
        for (JFieldVar jvar : jclass.fields().values()) {
            if ((jvar.mods().getValue() & 0x10) == 16) continue;
            toString.body().assignPlus((JAssignmentTarget)result, JExpr.lit((String)((first ? "" : ", ") + jvar.name() + "=")).plus((JExpression)jvar));
            first = false;
        }
        toString.body()._return(result.plus(JExpr.lit((String)"]")));
    }

    public static void addEquals(JDefinedClass jclass, JCodeModel jCodeModel, boolean includeSuperEquals) {
        JMethod equals = jclass.method(1, (JType)jCodeModel.BOOLEAN, "equals");
        JVar _obj = equals.param((JType)jCodeModel.ref(Object.class), "obj");
        if (includeSuperEquals) {
            equals.body()._if(JExpr.FALSE.eq((JExpression)JExpr._super().invoke("equals").arg((JExpression)_obj)))._then()._return(JExpr.FALSE);
        }
        equals.body().directStatement("\tif (this == obj)\n\t\treturn true;\n\tif (obj == null)\n\t\treturn false;\n\tif (getClass() != obj.getClass())\treturn false;");
        JVar _other = equals.body().decl((JType)jclass, "other", (JExpression)JExpr.cast((JType)jclass, (JExpression)_obj));
        for (JFieldVar jvar : jclass.fields().values()) {
            if ((jvar.mods().getValue() & 0x10) == 16) continue;
            JConditional _outerIf = equals.body()._if(jvar.eq(JExpr._null()));
            _outerIf._then()._if(_other.ref(jvar.name()).ne(JExpr._null()))._then()._return(JExpr.FALSE);
            _outerIf._else()._if(jvar.invoke("equals").arg((JExpression)_other.ref(jvar.name())).not())._then()._return(JExpr.FALSE);
        }
        equals.body()._return(JExpr.TRUE);
    }
}

