/*
 * Decompiled with CFR 0.152.
 */
package com.java_podio.code_gen;

import com.google.common.base.CaseFormat;
import com.java_podio.code_gen.JavaNames;
import com.java_podio.code_gen.static_classes.PodioCategory;
import com.podio.app.ApplicationField;
import com.podio.app.CategoryOption;
import com.podio.app.CategoryOptionStatus;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JEnumConstant;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JForEach;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;

public class EnumGenerator {
    private JCodeModel jc;
    private JPackage jp;

    public EnumGenerator(JCodeModel jCodeModel, JPackage jp) {
        this.jc = jCodeModel;
        this.jp = jp;
    }

    public JDefinedClass generateEnum(ApplicationField f, String name) throws JClassAlreadyExistsException {
        JDefinedClass result = this.jp != null ? this.jp._enum(name) : this.jc._package("")._enum(name);
        result._implements(PodioCategory.class);
        JFieldVar podioId = result.field(4, (JType)this.jc.INT, "podioId");
        JFieldVar value = result.field(4, (JType)this.jc.ref(String.class), "value");
        JMethod constructor = result.constructor(4);
        JVar constructorPodioIdParam = constructor.param((JType)this.jc.INT, "podioId");
        JVar constructorToStringParam = constructor.param((JType)this.jc.ref(String.class), "value");
        constructor.body().assign((JAssignmentTarget)JExpr._this().ref((JVar)podioId), (JExpression)constructorPodioIdParam);
        constructor.body().assign((JAssignmentTarget)JExpr._this().ref((JVar)value), (JExpression)constructorToStringParam);
        result.method(1, String.class, "toString").body()._return((JExpression)value);
        result.method(1, (JType)this.jc.INT, "getPodioId").body()._return((JExpression)podioId);
        JMethod byId = result.method(17, (JType)result, "byId");
        byId.javadoc().addReturn().add((Object)"{@code null}, if no element with given {@code id} exists.");
        JVar byIdParam = byId.param((JType)this.jc.INT, "podioId");
        JForEach forEach = byId.body().forEach((JType)result, "e", (JExpression)result.staticInvoke("values"));
        forEach.body()._if(byIdParam.eq((JExpression)forEach.var().invoke("getPodioId")))._then()._return((JExpression)forEach.var());
        byId.body()._return(JExpr._null());
        result.enumConstant("NONE").arg(JExpr.lit((int)0)).arg(JExpr.lit((String)"--"));
        for (CategoryOption option : f.getConfiguration().getSettings().getOptions()) {
            String constantName = JavaNames.createValidJavaTypeName(option.getText(), name);
            String finalConstantName = CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, constantName);
            JEnumConstant constant = result.enumConstant(finalConstantName);
            constant.arg(JExpr.lit((int)option.getId())).arg(JExpr.lit((String)option.getText()));
            if (!option.getStatus().equals((Object)CategoryOptionStatus.DELETED)) continue;
            constant.annotate(Deprecated.class);
        }
        return result;
    }
}

