/*
 * Decompiled with CFR 0.152.
 */
package com.java_podio.code_gen.static_classes;

import com.podio.item.FieldValuesUpdate;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class PodioDate
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final ThreadLocal<SimpleDateFormat> PODIO_DATE_TIME_FORMATTER = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };
    public static final ThreadLocal<SimpleDateFormat> PODIO_DATE_FORMATTER = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd");
        }
    };
    public static final ThreadLocal<SimpleDateFormat> PODIO_TIME_FORMATTER = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("HH:mm:ss");
        }
    };
    private Date start = null;
    private boolean startTime = true;
    private boolean startDate = true;
    private Date end = null;
    private boolean endTime = true;
    private boolean endDate = true;

    public PodioDate() {
    }

    public PodioDate(String start, String end) throws ParseException {
        if (start != null && !start.equals("")) {
            this.setStartDate(true);
            this.setStart(PODIO_DATE_TIME_FORMATTER.get().parse(start));
            if (start.substring(11).equals("00:00:00")) {
                this.setStartTime(false);
            } else {
                this.setStartTime(true);
            }
        } else {
            this.setStartDate(false);
            this.setStartTime(false);
        }
        if (end != null && !end.equals("")) {
            this.setEndDate(true);
            this.setEnd(PODIO_DATE_TIME_FORMATTER.get().parse(end));
            if (end.substring(11).equals("00:00:00")) {
                this.setEndTime(false);
            } else {
                this.setEndTime(true);
            }
        } else {
            this.setEndDate(false);
            this.setEndTime(false);
        }
    }

    public PodioDate(Date start, Date end) {
        this.setStart(start);
        this.setEnd(end);
    }

    public Date getStart() {
        return this.start;
    }

    public Date getEnd() {
        return this.end;
    }

    public void setStart(Date start) {
        this.start = start;
        if (start == null) {
            this.setStartDate(false);
            this.setStartTime(false);
        } else {
            this.setStartDate(true);
        }
    }

    public void setEnd(Date end) {
        this.end = end;
        if (end == null) {
            this.setEndDate(false);
            this.setEndTime(false);
        } else {
            this.setEndDate(true);
        }
    }

    public boolean isStartTime() {
        return this.startTime;
    }

    public boolean isStartDate() {
        return this.startDate;
    }

    public boolean isEndTime() {
        return this.endTime;
    }

    public boolean isEndDate() {
        return this.endDate;
    }

    public void setStartTime(boolean startTime) {
        this.startTime = startTime;
    }

    public void setStartDate(boolean startDate) {
        this.startDate = startDate;
    }

    public void setEndTime(boolean endTime) {
        this.endTime = endTime;
    }

    public void setEndDate(boolean endDate) {
        this.endDate = endDate;
    }

    public FieldValuesUpdate getFieldValuesUpdate(String externalId) {
        if (!this.isStartDate() && this.isEndDate()) {
            throw new IllegalStateException("Must have a start date, when having an end date!");
        }
        HashMap<String, Object> dateHashMap = new HashMap<String, Object>();
        if (this.isStartDate()) {
            dateHashMap.put("start", this.isStartTime() ? PODIO_DATE_TIME_FORMATTER.get().format(this.start) : PODIO_DATE_FORMATTER.get().format(this.start) + " 00:00:00");
            dateHashMap.put("start_date", PODIO_DATE_FORMATTER.get().format(this.start));
            dateHashMap.put("start_time", this.isStartTime() ? PODIO_TIME_FORMATTER.get().format(this.start) : null);
        }
        if (this.isEndDate()) {
            dateHashMap.put("end", this.isEndTime() ? PODIO_DATE_TIME_FORMATTER.get().format(this.end) : PODIO_DATE_FORMATTER.get().format(this.end) + " 00:00:00");
            dateHashMap.put("end_date", PODIO_DATE_FORMATTER.get().format(this.end));
            dateHashMap.put("end_time", this.isEndTime() ? PODIO_TIME_FORMATTER.get().format(this.end) : null);
        }
        return new FieldValuesUpdate(externalId, dateHashMap);
    }

    public static Date parseDate(String dateOrDateTime) throws ParseException {
        if (dateOrDateTime.length() <= 10) {
            return PODIO_DATE_FORMATTER.get().parse(dateOrDateTime);
        }
        return PODIO_DATE_TIME_FORMATTER.get().parse(dateOrDateTime);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.end == null ? 0 : this.end.hashCode());
        result = 31 * result + (this.endDate ? 1231 : 1237);
        result = 31 * result + (this.endTime ? 1231 : 1237);
        result = 31 * result + (this.start == null ? 0 : this.start.hashCode());
        result = 31 * result + (this.startDate ? 1231 : 1237);
        result = 31 * result + (this.startTime ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PodioDate other = (PodioDate)obj;
        if (this.end == null ? other.end != null : !this.end.equals(other.end)) {
            return false;
        }
        if (this.endDate != other.endDate) {
            return false;
        }
        if (this.endTime != other.endTime) {
            return false;
        }
        if (this.start == null ? other.start != null : !this.start.equals(other.start)) {
            return false;
        }
        if (this.startDate != other.startDate) {
            return false;
        }
        return this.startTime == other.startTime;
    }

    public String toString() {
        return "PodioDate [start=" + this.start + ", startTime=" + this.startTime + ", startDate=" + this.startDate + ", end=" + this.end + ", endTime=" + this.endTime + ", endDate=" + this.endDate + "]";
    }
}

