/*
 * Decompiled with CFR 0.152.
 */
package com.java_podio.code_gen.static_interface;

import com.java_podio.code_gen.static_interface.GenericPodioInterface;
import com.podio.APIApplicationException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class RateLimitRetry {
    private static final int NUMBER_OF_RETRIES = 3;
    private static final Logger LOGGER = Logger.getLogger(RateLimitRetry.class.getName());
    private static List<RateLimitHitListener> listener = new LinkedList<RateLimitHitListener>();

    public static void addRateLimitHitListener(RateLimitHitListener l) {
        listener.add(l);
    }

    public static void removeRateLimitHitListener(RateLimitHitListener l) {
        listener.remove(l);
    }

    public static <T extends GenericPodioInterface> T proxify(T original, Class<T> interfaceType) {
        LOGGER.info("Using GenericPodioInterfaceProxy on " + original.getClass().getCanonicalName());
        return (T)((GenericPodioInterface)Proxy.newProxyInstance(interfaceType.getClassLoader(), new Class[]{interfaceType}, new RateLimitInvokationHandler<T>(original, interfaceType)));
    }

    public static interface RateLimitHitListener {
        public void hitRateLimit(int var1, int var2);
    }

    private static class RateLimitInvokationHandler<T extends GenericPodioInterface>
    implements InvocationHandler {
        private final T original;

        public RateLimitInvokationHandler(T original, Class<T> interfaceType) {
            this.original = original;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            int i = 0;
            while (true) {
                if (i > 3) {
                    LOGGER.severe("this should never happen!");
                    throw new RetriesFailedException("giving up after 3 retries. (invalid code path!)");
                }
                try {
                    return method.invoke(this.original, args);
                }
                catch (InvocationTargetException e) {
                    if (i == 3) {
                        LOGGER.warning("giving up after 3 retries.");
                        throw new RetriesFailedException("giving up after 3 retries.", e);
                    }
                    if (e.getCause() instanceof APIApplicationException && "rate_limit".equals(((APIApplicationException)e.getCause()).getError())) {
                        APIApplicationException exc = (APIApplicationException)e.getCause();
                        Pattern pattern = Pattern.compile("Please wait (\\d+) seconds", 2);
                        Matcher matcher = pattern.matcher(exc.getDescription());
                        if (!matcher.find()) {
                            LOGGER.warning("could not parse wait time from: " + exc.getDescription() + " (throwing exception)");
                            throw e;
                        }
                        String seconds = matcher.group(1);
                        LOGGER.info("should wait for " + seconds + " seconds..");
                        int secondsInt = Integer.parseInt(seconds);
                        for (RateLimitHitListener l : listener) {
                            l.hitRateLimit(i, secondsInt);
                        }
                        Thread.sleep(secondsInt * 1000);
                        LOGGER.info("waking up, trying again..");
                        ++i;
                        continue;
                    }
                    LOGGER.log(Level.INFO, "non rate limit exception occured..", e);
                    throw e;
                }
                break;
            }
        }
    }

    public static class RetriesFailedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public RetriesFailedException(String message, Throwable cause) {
            super(message, cause);
        }

        public RetriesFailedException(String message) {
            super(message);
        }
    }
}

