/*
 * Decompiled with CFR 0.152.
 */
package com.github.ddth.queue;

import com.github.ddth.commons.utils.IdGenerator;
import com.github.ddth.commons.utils.SerializationUtils;
import com.github.ddth.dao.BaseBo;
import com.github.ddth.queue.IQueueMessage;
import com.github.ddth.queue.utils.QueueUtils;
import java.util.Date;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public class UniversalQueueMessage
extends BaseBo
implements IQueueMessage {
    private static IdGenerator IDGEN = IdGenerator.getInstance((long)IdGenerator.getMacAddr());
    public static final String FIELD_QUEUE_ID = "queue_id";
    public static final String FIELD_ORG_TIMESTAMP = "org_timestamp";
    public static final String FIELD_TIMESTAMP = "timestamp";
    public static final String FIELD_NUM_REQUEUES = "num_requeues";
    public static final String FIELD_CONTENT = "content";
    private static final Long ZERO = new Long(0L);

    public static UniversalQueueMessage newInstance() {
        Date now = new Date();
        UniversalQueueMessage msg = new UniversalQueueMessage();
        msg.qId(IDGEN.generateId64()).qNumRequeues(0).qOriginalTimestamp(now).qTimestamp(now);
        return msg;
    }

    @Override
    public Long qId() {
        Long value = (Long)this.getAttribute(FIELD_QUEUE_ID, Long.class);
        return value != null ? value : ZERO;
    }

    @Override
    public UniversalQueueMessage qId(Object queueId) {
        long value = queueId instanceof Number ? ((Number)queueId).longValue() : 0L;
        return (UniversalQueueMessage)this.setAttribute(FIELD_QUEUE_ID, value);
    }

    @Override
    public Date qOriginalTimestamp() {
        return (Date)this.getAttribute(FIELD_ORG_TIMESTAMP, Date.class);
    }

    @Override
    public UniversalQueueMessage qOriginalTimestamp(Date timestamp) {
        return (UniversalQueueMessage)this.setAttribute(FIELD_ORG_TIMESTAMP, timestamp);
    }

    @Override
    public Date qTimestamp() {
        return (Date)this.getAttribute(FIELD_TIMESTAMP, Date.class);
    }

    @Override
    public UniversalQueueMessage qTimestamp(Date timestamp) {
        return (UniversalQueueMessage)this.setAttribute(FIELD_TIMESTAMP, timestamp);
    }

    @Override
    public int qNumRequeues() {
        Integer value = (Integer)this.getAttribute(FIELD_NUM_REQUEUES, Integer.class);
        return value != null ? value : 0;
    }

    @Override
    public UniversalQueueMessage qNumRequeues(int numRequeues) {
        return (UniversalQueueMessage)this.setAttribute(FIELD_NUM_REQUEUES, numRequeues);
    }

    @Override
    public UniversalQueueMessage qIncNumRequeues() {
        return this.qNumRequeues(this.qNumRequeues() + 1);
    }

    public byte[] content() {
        return (byte[])this.getAttribute(FIELD_CONTENT, byte[].class);
    }

    public UniversalQueueMessage content(byte[] content) {
        return (UniversalQueueMessage)this.setAttribute(FIELD_CONTENT, content);
    }

    public byte[] toBytes() {
        Map dataMap = this.toMap();
        byte[] content = this.content();
        String contentStr = content != null ? Base64.encodeBase64String((byte[])content) : null;
        dataMap.put(FIELD_CONTENT, contentStr);
        return SerializationUtils.toJsonString((Object)dataMap).getBytes(QueueUtils.UTF8);
    }

    public static UniversalQueueMessage fromBytes(byte[] msgData) {
        if (msgData == null) {
            return null;
        }
        String msgDataJson = new String(msgData, QueueUtils.UTF8);
        Map dataMap = (Map)SerializationUtils.fromJsonString((String)msgDataJson, Map.class);
        Object content = dataMap.get(FIELD_CONTENT);
        byte[] contentData = content == null ? null : (content instanceof byte[] ? (byte[])content : Base64.decodeBase64((String)content.toString()));
        dataMap.put(FIELD_CONTENT, contentData);
        UniversalQueueMessage msg = new UniversalQueueMessage();
        msg.fromMap(dataMap);
        return msg;
    }
}

