/*
 * Decompiled with CFR 0.152.
 */
package com.github.ddth.queue.impl;

import com.github.ddth.dao.jdbc.BaseJdbcDao;
import com.github.ddth.queue.IQueue;
import com.github.ddth.queue.IQueueMessage;
import com.github.ddth.queue.utils.QueueException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.PessimisticLockingFailureException;
import org.springframework.jdbc.core.JdbcTemplate;

public abstract class JdbcQueue
extends BaseJdbcDao
implements IQueue {
    public static int DEFAULT_MAX_RETRIES = 3;
    private Logger LOGGER = LoggerFactory.getLogger(JdbcQueue.class);
    private String tableName;
    private String tableNameEphemeral;
    private String SQL_COUNT = "SELECT COUNT(*) AS num_entries FROM {0}";
    private String SQL_COUNT_EPHEMERAL = "SELECT COUNT(*) AS num_entries FROM {0}";
    private int maxRetries = DEFAULT_MAX_RETRIES;
    private int transactionIsolationLevel = 2;

    public JdbcQueue setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public String getTableName() {
        return this.tableName;
    }

    public JdbcQueue setTableNameEphemeral(String tableNameEphemeral) {
        this.tableNameEphemeral = tableNameEphemeral;
        return this;
    }

    public String getTableNameEphemeral() {
        return this.tableNameEphemeral;
    }

    public JdbcQueue setTransactionIsolationLevel(int transactionIsolationLevel) {
        this.transactionIsolationLevel = transactionIsolationLevel;
        return this;
    }

    public int getTransactionIsolationLevel() {
        return this.transactionIsolationLevel;
    }

    public JdbcQueue setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public JdbcQueue init() {
        this.SQL_COUNT = MessageFormat.format(this.SQL_COUNT, this.tableName);
        this.SQL_COUNT_EPHEMERAL = MessageFormat.format(this.SQL_COUNT_EPHEMERAL, this.tableNameEphemeral);
        return (JdbcQueue)super.init();
    }

    public void destroy() {
        super.destroy();
    }

    protected abstract IQueueMessage readFromQueueStorage(JdbcTemplate var1);

    protected abstract IQueueMessage readFromEphemeralStorage(JdbcTemplate var1, IQueueMessage var2);

    protected abstract Collection<IQueueMessage> getOrphanFromEphemeralStorage(JdbcTemplate var1, long var2);

    protected abstract boolean putToQueueStorage(JdbcTemplate var1, IQueueMessage var2);

    protected abstract boolean putToEphemeralStorage(JdbcTemplate var1, IQueueMessage var2);

    protected abstract boolean removeFromQueueStorage(JdbcTemplate var1, IQueueMessage var2);

    protected abstract boolean removeFromEphemeralStorage(JdbcTemplate var1, IQueueMessage var2);

    protected boolean _queueWithRetries(Connection conn, IQueueMessage msg, int numRetries, int maxRetries) throws SQLException {
        try {
            JdbcTemplate jdbcTemplate = this.jdbcTemplate(conn);
            Date now = new Date();
            msg.qNumRequeues(0).qOriginalTimestamp(now).qTimestamp(now);
            boolean result = this.putToQueueStorage(jdbcTemplate, msg);
            return result;
        }
        catch (DuplicateKeyException dke) {
            this.LOGGER.warn(dke.getMessage(), (Throwable)dke);
            return true;
        }
        catch (PessimisticLockingFailureException ex) {
            if (numRetries > maxRetries) {
                throw new QueueException(ex);
            }
            return this._queueWithRetries(conn, msg, numRetries + 1, maxRetries);
        }
        catch (Exception e) {
            throw new QueueException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean queue(IQueueMessage msg) {
        boolean bl;
        if (msg == null) {
            return false;
        }
        Connection conn = this.connection();
        try {
            boolean result;
            bl = result = this._queueWithRetries(conn, msg, 0, this.maxRetries);
        }
        catch (Throwable throwable) {
            try {
                this.returnConnection(conn);
                throw throwable;
            }
            catch (Exception e) {
                String logMsg = "(queue) Exception [" + e.getClass().getName() + "]: " + e.getMessage();
                this.LOGGER.error(logMsg, (Throwable)e);
                if (e instanceof QueueException) {
                    throw (QueueException)e;
                }
                throw new QueueException(e);
            }
        }
        this.returnConnection(conn);
        return bl;
    }

    protected boolean _requeueWithRetries(Connection conn, IQueueMessage msg, int numRetries, int maxRetries) throws SQLException {
        try {
            this.startTransaction(conn);
            conn.setTransactionIsolation(this.transactionIsolationLevel);
            JdbcTemplate jdbcTemplate = this.jdbcTemplate(conn);
            this.removeFromEphemeralStorage(jdbcTemplate, msg);
            Date now = new Date();
            msg.qIncNumRequeues().qTimestamp(now);
            boolean result = this.putToQueueStorage(jdbcTemplate, msg);
            this.commitTransaction(conn);
            return result;
        }
        catch (DuplicateKeyException dke) {
            this.LOGGER.warn(dke.getMessage(), (Throwable)dke);
            return true;
        }
        catch (PessimisticLockingFailureException ex) {
            this.rollbackTransaction(conn);
            if (numRetries > maxRetries) {
                throw new QueueException(ex);
            }
            return this._requeueSilentWithRetries(conn, msg, numRetries + 1, maxRetries);
        }
        catch (Exception e) {
            this.rollbackTransaction(conn);
            throw new QueueException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requeue(IQueueMessage msg) {
        boolean bl;
        if (msg == null) {
            return false;
        }
        Connection conn = this.connection();
        try {
            boolean result;
            bl = result = this._requeueWithRetries(conn, msg, 0, this.maxRetries);
        }
        catch (Throwable throwable) {
            try {
                this.returnConnection(conn);
                throw throwable;
            }
            catch (Exception e) {
                String logMsg = "(requeue) Exception [" + e.getClass().getName() + "]: " + e.getMessage();
                this.LOGGER.error(logMsg, (Throwable)e);
                if (e instanceof QueueException) {
                    throw (QueueException)e;
                }
                throw new QueueException(e);
            }
        }
        this.returnConnection(conn);
        return bl;
    }

    protected boolean _requeueSilentWithRetries(Connection conn, IQueueMessage msg, int numRetries, int maxRetries) throws SQLException {
        try {
            this.startTransaction(conn);
            conn.setTransactionIsolation(this.transactionIsolationLevel);
            JdbcTemplate jdbcTemplate = this.jdbcTemplate(conn);
            this.removeFromEphemeralStorage(jdbcTemplate, msg);
            boolean result = this.putToQueueStorage(jdbcTemplate, msg);
            this.commitTransaction(conn);
            return result;
        }
        catch (DuplicateKeyException dke) {
            this.LOGGER.warn(dke.getMessage(), (Throwable)dke);
            return true;
        }
        catch (PessimisticLockingFailureException ex) {
            this.rollbackTransaction(conn);
            if (numRetries > maxRetries) {
                throw new QueueException(ex);
            }
            return this._requeueSilentWithRetries(conn, msg, numRetries + 1, maxRetries);
        }
        catch (Exception e) {
            this.rollbackTransaction(conn);
            throw new QueueException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requeueSilent(IQueueMessage msg) {
        boolean bl;
        if (msg == null) {
            return false;
        }
        Connection conn = this.connection();
        try {
            boolean result;
            bl = result = this._requeueSilentWithRetries(conn, msg, 0, this.maxRetries);
        }
        catch (Throwable throwable) {
            try {
                this.returnConnection(conn);
                throw throwable;
            }
            catch (Exception e) {
                String logMsg = "(requeueSilent) Exception [" + e.getClass().getName() + "]: " + e.getMessage();
                this.LOGGER.error(logMsg, (Throwable)e);
                if (e instanceof QueueException) {
                    throw (QueueException)e;
                }
                throw new QueueException(e);
            }
        }
        this.returnConnection(conn);
        return bl;
    }

    protected void _finishWithRetries(Connection conn, IQueueMessage msg, int numRetries, int maxRetries) throws SQLException {
        try {
            JdbcTemplate jdbcTemplate = this.jdbcTemplate(conn);
            this.removeFromEphemeralStorage(jdbcTemplate, msg);
        }
        catch (PessimisticLockingFailureException ex) {
            if (numRetries > maxRetries) {
                throw new QueueException(ex);
            }
            this._finishWithRetries(conn, msg, numRetries + 1, maxRetries);
        }
        catch (Exception e) {
            throw new QueueException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish(IQueueMessage msg) {
        if (msg == null) {
            return;
        }
        try {
            Connection conn = this.connection();
            try {
                this._finishWithRetries(conn, msg, 0, this.maxRetries);
            }
            finally {
                this.returnConnection(conn);
            }
        }
        catch (Exception e) {
            String logMsg = "(finish) Exception [" + e.getClass().getName() + "]: " + e.getMessage();
            this.LOGGER.error(logMsg, (Throwable)e);
            if (e instanceof QueueException) {
                throw (QueueException)e;
            }
            throw new QueueException(e);
        }
    }

    protected IQueueMessage _takeWithRetries(Connection conn, int numRetries, int maxRetries) throws SQLException {
        try {
            this.startTransaction(conn);
            conn.setTransactionIsolation(this.transactionIsolationLevel);
            JdbcTemplate jdbcTemplate = this.jdbcTemplate(conn);
            boolean result = true;
            IQueueMessage msg = this.readFromQueueStorage(jdbcTemplate);
            if (msg != null) {
                result = result && this.removeFromQueueStorage(jdbcTemplate, msg);
                try {
                    result = result && this.putToEphemeralStorage(jdbcTemplate, msg);
                }
                catch (DuplicateKeyException dke) {
                    this.LOGGER.warn(dke.getMessage(), (Throwable)dke);
                }
            }
            if (result) {
                this.commitTransaction(conn);
                return msg;
            }
            this.rollbackTransaction(conn);
            return null;
        }
        catch (PessimisticLockingFailureException ex) {
            this.rollbackTransaction(conn);
            if (numRetries > maxRetries) {
                throw new QueueException(ex);
            }
            return this._takeWithRetries(conn, numRetries + 1, maxRetries);
        }
        catch (Exception e) {
            this.rollbackTransaction(conn);
            throw new QueueException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IQueueMessage take() {
        IQueueMessage iQueueMessage;
        Connection conn = this.connection();
        try {
            IQueueMessage result;
            iQueueMessage = result = this._takeWithRetries(conn, 0, this.maxRetries);
        }
        catch (Throwable throwable) {
            try {
                this.returnConnection(conn);
                throw throwable;
            }
            catch (Exception e) {
                String logMsg = "(take) Exception [" + e.getClass().getName() + "]: " + e.getMessage();
                this.LOGGER.error(logMsg, (Throwable)e);
                if (e instanceof QueueException) {
                    throw (QueueException)e;
                }
                throw new QueueException(e);
            }
        }
        this.returnConnection(conn);
        return iQueueMessage;
    }

    protected Collection<IQueueMessage> _getOrphanMessagesWithRetries(long thresholdTimestampMs, Connection conn, int numRetries, int maxRetries) throws SQLException {
        try {
            this.startTransaction(conn);
            conn.setTransactionIsolation(this.transactionIsolationLevel);
            JdbcTemplate jdbcTemplate = this.jdbcTemplate(conn);
            Collection<IQueueMessage> msgs = this.getOrphanFromEphemeralStorage(jdbcTemplate, thresholdTimestampMs);
            this.commitTransaction(conn);
            return msgs;
        }
        catch (PessimisticLockingFailureException ex) {
            this.rollbackTransaction(conn);
            if (numRetries > maxRetries) {
                throw new QueueException(ex);
            }
            return this._getOrphanMessagesWithRetries(thresholdTimestampMs, conn, numRetries + 1, maxRetries);
        }
        catch (Exception e) {
            this.rollbackTransaction(conn);
            throw new QueueException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<IQueueMessage> getOrphanMessages(long thresholdTimestampMs) {
        Collection<IQueueMessage> collection;
        Connection conn = this.connection();
        try {
            Collection<IQueueMessage> result;
            collection = result = this._getOrphanMessagesWithRetries(thresholdTimestampMs, conn, 0, this.maxRetries);
        }
        catch (Throwable throwable) {
            try {
                this.returnConnection(conn);
                throw throwable;
            }
            catch (Exception e) {
                String logMsg = "(getOrphanMessages) Exception [" + e.getClass().getName() + "]: " + e.getMessage();
                this.LOGGER.error(logMsg, (Throwable)e);
                if (e instanceof QueueException) {
                    throw (QueueException)e;
                }
                throw new QueueException(e);
            }
        }
        this.returnConnection(conn);
        return collection;
    }

    protected boolean _moveFromEphemeralToQueueStorageWithRetries(IQueueMessage msg, Connection conn, int numRetries, int maxRetries) throws SQLException {
        try {
            this.startTransaction(conn);
            conn.setTransactionIsolation(this.transactionIsolationLevel);
            JdbcTemplate jdbcTemplate = this.jdbcTemplate(conn);
            IQueueMessage orphanMsg = this.readFromEphemeralStorage(jdbcTemplate, msg);
            if (orphanMsg != null) {
                this.removeFromEphemeralStorage(jdbcTemplate, msg);
                boolean result = this.putToQueueStorage(jdbcTemplate, msg);
                this.commitTransaction(conn);
                return result;
            }
            this.rollbackTransaction(conn);
            return false;
        }
        catch (PessimisticLockingFailureException ex) {
            this.rollbackTransaction(conn);
            if (numRetries > maxRetries) {
                throw new QueueException(ex);
            }
            return this._moveFromEphemeralToQueueStorageWithRetries(msg, conn, numRetries + 1, maxRetries);
        }
        catch (Exception e) {
            this.rollbackTransaction(conn);
            throw new QueueException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean moveFromEphemeralToQueueStorage(IQueueMessage msg) {
        boolean bl;
        Connection conn = this.connection();
        try {
            boolean result;
            bl = result = this._moveFromEphemeralToQueueStorageWithRetries(msg, conn, 0, this.maxRetries);
        }
        catch (Throwable throwable) {
            try {
                this.returnConnection(conn);
                throw throwable;
            }
            catch (Exception e) {
                String logMsg = "(moveFromEphemeralToQueueStorage) Exception [" + e.getClass().getName() + "]: " + e.getMessage();
                this.LOGGER.error(logMsg, (Throwable)e);
                if (e instanceof QueueException) {
                    throw (QueueException)e;
                }
                throw new QueueException(e);
            }
        }
        this.returnConnection(conn);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int queueSize() {
        int n;
        Connection conn = this.connection();
        try {
            JdbcTemplate jdbcTemplate = this.jdbcTemplate(conn);
            Integer result = (Integer)jdbcTemplate.queryForObject(this.SQL_COUNT, null, Integer.class);
            n = result != null ? result : 0;
        }
        catch (Throwable throwable) {
            try {
                this.returnConnection(conn);
                throw throwable;
            }
            catch (Exception e) {
                String logMsg = "(queueSize) Exception [" + e.getClass().getName() + "]: " + e.getMessage();
                this.LOGGER.error(logMsg, (Throwable)e);
                return -1;
            }
        }
        this.returnConnection(conn);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int ephemeralSize() {
        int n;
        Connection conn = this.connection();
        try {
            JdbcTemplate jdbcTemplate = this.jdbcTemplate(conn);
            Integer result = (Integer)jdbcTemplate.queryForObject(this.SQL_COUNT_EPHEMERAL, null, Integer.class);
            n = result != null ? result : 0;
        }
        catch (Throwable throwable) {
            try {
                this.returnConnection(conn);
                throw throwable;
            }
            catch (Exception e) {
                String logMsg = "(ephemeralSize) Exception [" + e.getClass().getName() + "]: " + e.getMessage();
                this.LOGGER.error(logMsg, (Throwable)e);
                return -1;
            }
        }
        this.returnConnection(conn);
        return n;
    }
}

