/*
 * Decompiled with CFR 0.152.
 */
package com.github.ddth.queue.impl;

import com.github.ddth.queue.IQueue;
import com.github.ddth.queue.IQueueMessage;
import com.github.ddth.queue.utils.QueueUtils;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Response;
import redis.clients.jedis.Transaction;

public abstract class RedisQueue
implements IQueue {
    private JedisPool jedisPool;
    private boolean myOwnJedisPool = true;
    private String redisHostAndPort = "localhost:6379";
    private String _redisHashName = "queue_h";
    private byte[] redisHashName = this._redisHashName.getBytes(QueueUtils.UTF8);
    private String _redisListName = "queue_l";
    private byte[] redisListName = this._redisListName.getBytes(QueueUtils.UTF8);
    private String _redisSortedSetName = "queue_s";
    private byte[] redisSortedSetName = this._redisSortedSetName.getBytes(QueueUtils.UTF8);
    private String SCRIPT_TAKE;
    private String SCRIPT_MOVE;

    public String getRedisHostAndPort() {
        return this.redisHostAndPort;
    }

    public RedisQueue setRedisHostAndPort(String redisHostAndPort) {
        this.redisHostAndPort = redisHostAndPort;
        return this;
    }

    public String getRedisHashName() {
        return this._redisHashName;
    }

    public RedisQueue setRedisHashName(String redisHashName) {
        this._redisHashName = redisHashName;
        this.redisHashName = this._redisHashName.getBytes(QueueUtils.UTF8);
        return this;
    }

    public String getRedisListName() {
        return this._redisListName;
    }

    public RedisQueue setRedisListName(String redisListName) {
        this._redisListName = redisListName;
        this.redisListName = this._redisListName.getBytes(QueueUtils.UTF8);
        return this;
    }

    public String getRedisSortedSetName() {
        return this._redisSortedSetName;
    }

    public RedisQueue setRedisSortedSetName(String redisSortedSetName) {
        this._redisSortedSetName = redisSortedSetName;
        this.redisSortedSetName = this._redisSortedSetName.getBytes(QueueUtils.UTF8);
        return this;
    }

    protected JedisPool getJedisPool() {
        return this.jedisPool;
    }

    public RedisQueue setJedisPool(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
        this.myOwnJedisPool = false;
        return this;
    }

    public RedisQueue init() {
        if (this.jedisPool == null) {
            JedisPoolConfig poolConfig = new JedisPoolConfig();
            poolConfig.setMaxTotal(32);
            poolConfig.setMinIdle(1);
            poolConfig.setMaxIdle(16);
            poolConfig.setMaxWaitMillis(10000L);
            poolConfig.setTestWhileIdle(true);
            String[] tokens = this.redisHostAndPort.split(":");
            String redisHost = tokens.length > 0 ? tokens[0] : "localhost";
            int redisPort = tokens.length > 1 ? Integer.parseInt(tokens[1]) : 6379;
            this.jedisPool = new JedisPool((GenericObjectPoolConfig)poolConfig, redisHost, redisPort);
            this.myOwnJedisPool = true;
        }
        this.SCRIPT_TAKE = "local qid=redis.call(\"lpop\",\"{0}\"); if qid then redis.call(\"zadd\", \"{1}\",  ARGV[1], qid); return redis.call(\"hget\", \"{2}\", qid) else return nil end";
        this.SCRIPT_TAKE = MessageFormat.format(this.SCRIPT_TAKE, this._redisListName, this._redisSortedSetName, this._redisHashName);
        this.SCRIPT_MOVE = "local result=redis.call(\"zrem\",\"{0}\",ARGV[1]); if result then redis.call(\"rpush\", \"{1}\",  ARGV[1]); return 1; else return 0; end";
        this.SCRIPT_MOVE = MessageFormat.format(this.SCRIPT_MOVE, this._redisSortedSetName, this._redisListName);
        return this;
    }

    public void destroy() {
        if (this.jedisPool != null && this.myOwnJedisPool) {
            this.jedisPool.destroy();
            this.jedisPool = null;
        }
    }

    protected abstract byte[] serialize(IQueueMessage var1);

    protected abstract IQueueMessage deserialize(byte[] var1);

    protected boolean remove(IQueueMessage msg) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Transaction jt = jedis.multi();
            byte[] field = msg.qId().toString().getBytes(QueueUtils.UTF8);
            Response response = jt.hdel(this.redisHashName, (byte[][])new byte[][]{field});
            jt.zrem(this.redisSortedSetName, (byte[][])new byte[][]{field});
            jt.exec();
            Long value = (Long)response.get();
            boolean bl = value != null && value > 1L;
            return bl;
        }
    }

    protected boolean storeNew(IQueueMessage msg) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Transaction jt = jedis.multi();
            byte[] field = msg.qId().toString().getBytes(QueueUtils.UTF8);
            byte[] data = this.serialize(msg);
            jt.hset(this.redisHashName, field, data);
            jt.rpush(this.redisListName, (byte[][])new byte[][]{field});
            jt.exec();
            boolean bl = true;
            return bl;
        }
    }

    protected boolean storeOld(IQueueMessage msg) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Transaction jt = jedis.multi();
            byte[] field = msg.qId().toString().getBytes(QueueUtils.UTF8);
            byte[] data = this.serialize(msg);
            jt.hset(this.redisHashName, field, data);
            jt.rpush(this.redisListName, (byte[][])new byte[][]{field});
            jt.zrem(this.redisSortedSetName, (byte[][])new byte[][]{field});
            jt.exec();
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public boolean queue(IQueueMessage msg) {
        Date now = new Date();
        msg.qNumRequeues(0).qOriginalTimestamp(now).qTimestamp(now);
        return this.storeNew(msg);
    }

    @Override
    public boolean requeue(IQueueMessage msg) {
        Date now = new Date();
        msg.qIncNumRequeues().qTimestamp(now);
        return this.storeOld(msg);
    }

    @Override
    public boolean requeueSilent(IQueueMessage msg) {
        return this.storeOld(msg);
    }

    @Override
    public void finish(IQueueMessage msg) {
        this.remove(msg);
    }

    @Override
    public IQueueMessage take() {
        try (Jedis jedis = this.jedisPool.getResource();){
            long timestamp = System.currentTimeMillis();
            Object response = jedis.eval(this.SCRIPT_TAKE, 0, new String[]{String.valueOf(timestamp)});
            if (response == null) {
                IQueueMessage iQueueMessage = null;
                return iQueueMessage;
            }
            IQueueMessage iQueueMessage = this.deserialize(response instanceof byte[] ? (byte[])response : response.toString().getBytes(QueueUtils.UTF8));
            return iQueueMessage;
        }
    }

    @Override
    public Collection<IQueueMessage> getOrphanMessages(long thresholdTimestampMs) {
        try (Jedis jedis = this.jedisPool.getResource();){
            HashSet<IQueueMessage> result = new HashSet<IQueueMessage>();
            byte[] min = "0".getBytes();
            byte[] max = String.valueOf(thresholdTimestampMs).getBytes();
            Set fields = jedis.zrangeByScore(this.redisSortedSetName, min, max, 0, 100);
            for (byte[] field : fields) {
                byte[] data = jedis.hget(this.redisHashName, field);
                IQueueMessage msg = this.deserialize(data);
                if (msg == null) continue;
                result.add(msg);
            }
            HashSet<IQueueMessage> hashSet = result;
            return hashSet;
        }
    }

    @Override
    public boolean moveFromEphemeralToQueueStorage(IQueueMessage msg) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Object response = jedis.eval(this.SCRIPT_MOVE, 0, new String[]{msg.qId().toString()});
            boolean bl = response != null && "1".equals(response.toString());
            return bl;
        }
    }

    @Override
    public int queueSize() {
        try (Jedis jedis = this.jedisPool.getResource();){
            Long result = jedis.hlen(this.redisHashName);
            int n = result != null ? result.intValue() : 0;
            return n;
        }
    }

    @Override
    public int ephemeralSize() {
        try (Jedis jedis = this.jedisPool.getResource();){
            Long result = jedis.zcard(this.redisSortedSetName);
            int n = result != null ? result.intValue() : 0;
            return n;
        }
    }
}

