/*
 * Decompiled with CFR 0.152.
 */
package com.github.ddth.queue.impl;

import com.github.ddth.queue.IQueueMessage;
import com.github.ddth.queue.UniversalQueueMessage;
import com.github.ddth.queue.impl.JdbcQueue;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.JdbcTemplate;

public class UniversalJdbcQueue
extends JdbcQueue {
    public static final String COL_QUEUE_ID = "queue_id";
    public static final String COL_ORG_TIMESTAMP = "msg_org_timestamp";
    public static final String COL_TIMESTAMP = "msg_timestamp";
    public static final String COL_NUM_REQUEUES = "msg_num_requeues";
    public static final String COL_CONTENT = "msg_content";
    private boolean fifo = true;
    private boolean ephemeralDisabled = false;
    private String SQL_READ_FROM_QUEUE;
    private String SQL_READ_FROM_EPHEMERAL;
    private String SQL_GET_ORPHAN_MSGS;
    private String SQL_PUT_NEW_TO_QUEUE;
    private String SQL_REPUT_TO_QUEUE;
    private String SQL_PUT_TO_EPHEMERAL;
    private String SQL_REMOVE_FROM_QUEUE;
    private String SQL_REMOVE_FROM_EPHEMERAL;

    public UniversalJdbcQueue setFifo(boolean fifo) {
        this.fifo = fifo;
        return this;
    }

    public UniversalJdbcQueue markFifo(boolean fifo) {
        this.fifo = fifo;
        return this;
    }

    public boolean isFifo() {
        return this.fifo;
    }

    public boolean getFifo() {
        return this.fifo;
    }

    public UniversalJdbcQueue setEphemeralDisabled(boolean ephemeralDisabled) {
        this.ephemeralDisabled = ephemeralDisabled;
        return this;
    }

    public UniversalJdbcQueue markEphemeralDisabled(boolean setEphemeralDisabled) {
        this.ephemeralDisabled = setEphemeralDisabled;
        return this;
    }

    public boolean isEphemeralDisabled() {
        return this.ephemeralDisabled;
    }

    public boolean getEphemeralDisabled() {
        return this.ephemeralDisabled;
    }

    @Override
    public UniversalJdbcQueue init() {
        super.init();
        this.SQL_READ_FROM_QUEUE = "SELECT {1}, {2}, {3}, {4}, {5} FROM {0}" + (this.fifo ? " ORDER BY queue_id DESC" : "") + " LIMIT 1";
        this.SQL_READ_FROM_QUEUE = MessageFormat.format(this.SQL_READ_FROM_QUEUE, this.getTableName(), "queue_id AS queue_id", "msg_org_timestamp AS org_timestamp", "msg_timestamp AS timestamp", "msg_num_requeues AS num_requeues", "msg_content AS content");
        this.SQL_READ_FROM_EPHEMERAL = "SELECT {1}, {2}, {3}, {4}, {5} FROM {0} WHERE queue_id=?";
        this.SQL_READ_FROM_EPHEMERAL = MessageFormat.format(this.SQL_READ_FROM_EPHEMERAL, this.getTableNameEphemeral(), "queue_id AS queue_id", "msg_org_timestamp AS org_timestamp", "msg_timestamp AS timestamp", "msg_num_requeues AS num_requeues", "msg_content AS content");
        this.SQL_GET_ORPHAN_MSGS = "SELECT {1}, {2}, {3}, {4}, {5} FROM {0} WHERE msg_timestamp<?";
        this.SQL_GET_ORPHAN_MSGS = MessageFormat.format(this.SQL_GET_ORPHAN_MSGS, this.getTableNameEphemeral(), "queue_id AS queue_id", "msg_org_timestamp AS org_timestamp", "msg_timestamp AS timestamp", "msg_num_requeues AS num_requeues", "msg_content AS content");
        this.SQL_PUT_NEW_TO_QUEUE = "INSERT INTO {0} ({1}, {2}, {3}, {4}) VALUES (?, ?, ?, ?)";
        this.SQL_PUT_NEW_TO_QUEUE = MessageFormat.format(this.SQL_PUT_NEW_TO_QUEUE, this.getTableName(), COL_ORG_TIMESTAMP, COL_TIMESTAMP, COL_NUM_REQUEUES, COL_CONTENT);
        this.SQL_REPUT_TO_QUEUE = "INSERT INTO {0} ({1}, {2}, {3}, {4}, {5}) VALUES (?, ?, ?, ?, ?)";
        this.SQL_REPUT_TO_QUEUE = MessageFormat.format(this.SQL_REPUT_TO_QUEUE, this.getTableName(), COL_QUEUE_ID, COL_ORG_TIMESTAMP, COL_TIMESTAMP, COL_NUM_REQUEUES, COL_CONTENT);
        this.SQL_PUT_TO_EPHEMERAL = "INSERT INTO {0} ({1}, {2}, {3}, {4}, {5}) VALUES (?, ?, ?, ?, ?)";
        this.SQL_PUT_TO_EPHEMERAL = MessageFormat.format(this.SQL_PUT_TO_EPHEMERAL, this.getTableNameEphemeral(), COL_QUEUE_ID, COL_ORG_TIMESTAMP, COL_TIMESTAMP, COL_NUM_REQUEUES, COL_CONTENT);
        this.SQL_REMOVE_FROM_QUEUE = "DELETE FROM {0} WHERE queue_id=?";
        this.SQL_REMOVE_FROM_QUEUE = MessageFormat.format(this.SQL_REMOVE_FROM_QUEUE, this.getTableName());
        this.SQL_REMOVE_FROM_EPHEMERAL = "DELETE FROM {0} WHERE queue_id=?";
        this.SQL_REMOVE_FROM_EPHEMERAL = MessageFormat.format(this.SQL_REMOVE_FROM_EPHEMERAL, this.getTableNameEphemeral());
        return this;
    }

    @Override
    protected UniversalQueueMessage readFromQueueStorage(JdbcTemplate jdbcTemplate) {
        List dbRows = jdbcTemplate.queryForList(this.SQL_READ_FROM_QUEUE);
        if (dbRows != null && dbRows.size() > 0) {
            Map dbRow = (Map)dbRows.get(0);
            UniversalQueueMessage msg = new UniversalQueueMessage();
            return (UniversalQueueMessage)msg.fromMap(dbRow);
        }
        return null;
    }

    @Override
    protected UniversalQueueMessage readFromEphemeralStorage(JdbcTemplate jdbcTemplate, IQueueMessage msg) {
        if (this.ephemeralDisabled) {
            return null;
        }
        List dbRows = jdbcTemplate.queryForList(this.SQL_READ_FROM_EPHEMERAL, new Object[]{msg.qId()});
        if (dbRows != null && dbRows.size() > 0) {
            Map dbRow = (Map)dbRows.get(0);
            UniversalQueueMessage myMsg = new UniversalQueueMessage();
            return (UniversalQueueMessage)myMsg.fromMap(dbRow);
        }
        return null;
    }

    @Override
    protected Collection<IQueueMessage> getOrphanFromEphemeralStorage(JdbcTemplate jdbcTemplate, long thresholdTimestampMs) {
        if (this.ephemeralDisabled) {
            return null;
        }
        Date threshold = new Date(thresholdTimestampMs);
        List dbRows = jdbcTemplate.queryForList(this.SQL_GET_ORPHAN_MSGS, new Object[]{threshold});
        if (dbRows != null && dbRows.size() > 0) {
            ArrayList<IQueueMessage> result = new ArrayList<IQueueMessage>();
            for (Map dbRow : dbRows) {
                UniversalQueueMessage msg = new UniversalQueueMessage();
                msg.fromMap(dbRow);
                result.add(msg);
            }
            return result;
        }
        return null;
    }

    @Override
    protected boolean putToQueueStorage(JdbcTemplate jdbcTemplate, IQueueMessage _msg) {
        if (!(_msg instanceof UniversalQueueMessage)) {
            throw new IllegalArgumentException("This method requires an argument of type [" + UniversalQueueMessage.class.getName() + "]!");
        }
        UniversalQueueMessage msg = (UniversalQueueMessage)_msg;
        Long qid = msg.qId();
        if (qid == null || qid == 0L) {
            int numRows = jdbcTemplate.update(this.SQL_PUT_NEW_TO_QUEUE, new Object[]{msg.qOriginalTimestamp(), msg.qTimestamp(), msg.qNumRequeues(), msg.content()});
            return numRows > 0;
        }
        int numRows = jdbcTemplate.update(this.SQL_REPUT_TO_QUEUE, new Object[]{qid, msg.qOriginalTimestamp(), msg.qTimestamp(), msg.qNumRequeues(), msg.content()});
        return numRows > 0;
    }

    @Override
    protected boolean putToEphemeralStorage(JdbcTemplate jdbcTemplate, IQueueMessage _msg) {
        if (this.ephemeralDisabled) {
            return true;
        }
        if (!(_msg instanceof UniversalQueueMessage)) {
            throw new IllegalArgumentException("This method requires an argument of type [" + UniversalQueueMessage.class.getName() + "]!");
        }
        UniversalQueueMessage msg = (UniversalQueueMessage)_msg;
        int numRows = jdbcTemplate.update(this.SQL_PUT_TO_EPHEMERAL, new Object[]{msg.qId(), msg.qOriginalTimestamp(), msg.qTimestamp(), msg.qNumRequeues(), msg.content()});
        return numRows > 0;
    }

    @Override
    protected boolean removeFromQueueStorage(JdbcTemplate jdbcTemplate, IQueueMessage _msg) {
        if (!(_msg instanceof UniversalQueueMessage)) {
            throw new IllegalArgumentException("This method requires an argument of type [" + UniversalQueueMessage.class.getName() + "]!");
        }
        UniversalQueueMessage msg = (UniversalQueueMessage)_msg;
        int numRows = jdbcTemplate.update(this.SQL_REMOVE_FROM_QUEUE, new Object[]{msg.qId()});
        return numRows > 0;
    }

    @Override
    protected boolean removeFromEphemeralStorage(JdbcTemplate jdbcTemplate, IQueueMessage _msg) {
        if (this.ephemeralDisabled) {
            return true;
        }
        if (!(_msg instanceof UniversalQueueMessage)) {
            throw new IllegalArgumentException("This method requires an argument of type [" + UniversalQueueMessage.class.getName() + "]!");
        }
        UniversalQueueMessage msg = (UniversalQueueMessage)_msg;
        int numRows = jdbcTemplate.update(this.SQL_REMOVE_FROM_EPHEMERAL, new Object[]{msg.qId()});
        return numRows > 0;
    }

    @Override
    public UniversalQueueMessage take() {
        return (UniversalQueueMessage)super.take();
    }
}

