/*
 * Decompiled with CFR 0.152.
 */
package develop.framework.application.jpa;

import develop.framework.application.jpa.BaseRepository;
import develop.framework.application.jpa.ResourceName;
import java.io.Serializable;
import javax.persistence.EntityManager;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;

public class BaseRepositoryImpl<T, ID extends Serializable>
extends SimpleJpaRepository<T, ID>
implements BaseRepository<T, ID> {
    private Class<T> domainClass;

    public BaseRepositoryImpl(Class<T> domainClass, EntityManager em) {
        super(domainClass, em);
        this.domainClass = domainClass;
    }

    @Override
    public boolean support(String resourceName) {
        if (AnnotationUtils.isAnnotationDeclaredLocally(ResourceName.class, this.domainClass)) {
            return ((ResourceName)AnnotationUtils.findAnnotation(this.domainClass, ResourceName.class)).value().equals(resourceName);
        }
        return false;
    }

    @Override
    public Class<T> getDomainClass() {
        return this.domainClass;
    }
}

