/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.expression;

import com.github.developframework.expression.ArrayExpression;
import com.github.developframework.expression.Expression;
import com.github.developframework.expression.ObjectExpression;
import com.github.developframework.expression.exception.ExpressionException;
import develop.toolkit.utils.JavaBeanUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class ExpressionUtils {
    private ExpressionUtils() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static final Object getValue(Object instance, String expressionValue) {
        return ExpressionUtils.getValue(instance, Expression.parse(expressionValue));
    }

    public static final <T> T getValue(Object instance, String expressionValue, Class<T> targetClass) {
        return ExpressionUtils.getValue(instance, Expression.parse(expressionValue), targetClass);
    }

    public static final <T> T getValue(Object instance, Expression expression, Class<T> targetClass) {
        return (T)ExpressionUtils.getValue(instance, expression);
    }

    public static final Object getValue(Object instance, Expression expression) {
        Objects.requireNonNull(instance);
        if (expression == null) {
            throw new ExpressionException("expression is null.");
        }
        if (expression == Expression.EMPTY_EXPRESSION) {
            return instance;
        }
        Expression[] expressionTree = expression.expressionTree();
        Object tempObject = instance;
        for (Expression singleExpression : expressionTree) {
            if (tempObject == null) {
                return null;
            }
            if (singleExpression instanceof ObjectExpression) {
                tempObject = ExpressionUtils.getValueFromObjectOrMap(tempObject, ((ObjectExpression)singleExpression).getPropertyName());
                continue;
            }
            if (!(singleExpression instanceof ArrayExpression)) continue;
            tempObject = ExpressionUtils.getValueFromArray(tempObject, (ArrayExpression)singleExpression);
        }
        return tempObject;
    }

    private static final Object getValueFromObjectOrMap(Object instance, String propertyName) {
        Class<?> clazz = instance.getClass();
        if (Map.class.isAssignableFrom(clazz)) {
            return ((Map)instance).get(propertyName);
        }
        Field field = ExpressionUtils.getDeclaredField(clazz, propertyName);
        return ExpressionUtils.getFieldValue(field, instance);
    }

    private static final Object getValueFromArray(Object instance, ArrayExpression arrayExpression) {
        Object arrayObject = instance;
        if (arrayExpression.hasPropertyName()) {
            arrayObject = ExpressionUtils.getValueFromObjectOrMap(instance, arrayExpression.getPropertyName());
        }
        if (arrayObject == null) {
            return null;
        }
        Class<?> clazz = arrayObject.getClass();
        if (clazz.isArray()) {
            return ((Object[])arrayObject)[arrayExpression.getIndex()];
        }
        if (List.class.isAssignableFrom(clazz)) {
            return ((List)arrayObject).get(arrayExpression.getIndex());
        }
        if (Set.class.isAssignableFrom(clazz)) {
            ArrayList<Object> arrayList = new ArrayList<Object>((Set)arrayObject);
            arrayList.sort(Comparator.comparingInt(Object::hashCode));
            return arrayList.get(arrayExpression.getIndex());
        }
        throw new ExpressionException("The instance \"%s\" type is not array or List/Set.", instance.toString());
    }

    private static Field getDeclaredField(Class<?> clazz, String propertyName) {
        for (Class<?> temp = clazz; temp != Object.class; temp = temp.getSuperclass()) {
            try {
                Field field = temp.getDeclaredField(propertyName);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        throw new ExpressionException("No such field \"%s\" in class \"%s\".", propertyName, clazz.getName());
    }

    private static Object getFieldValue(Field field, Object instance) {
        String getterMethodName = JavaBeanUtils.getGetterMethodName((String)field.getName(), field.getType());
        Class<?> instanceClass = instance.getClass();
        try {
            Method getterMethod = instanceClass.getMethod(getterMethodName, new Class[0]);
            return getterMethod.invoke(instance, (Object[])new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                return field.get(instance);
            }
            catch (IllegalAccessException e1) {
                throw new ExpressionException("Illegal access field \"%s\" in class \"%s\".", field.getName(), instanceClass.getName());
            }
        }
        catch (Exception e) {
            throw new ExpressionException("%s invoke failed.", getterMethodName);
        }
    }
}

