package com.github.developframework.jsonview.core;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.jsonview.core.element.Jsonview;
import com.github.developframework.jsonview.core.element.JsonviewConfiguration;
import com.github.developframework.jsonview.core.processor.Context;
import com.github.developframework.jsonview.core.processor.JsonviewProcessor;
import com.github.developframework.jsonview.data.DataModel;

/**
 * json creator implemention
 * 
 * @author qiuzhenhao
 *
 */
class JsonCreatorImpl implements JsonCreator {

	private JsonviewConfiguration jsonviewConfiguration;

	protected JsonCreatorImpl(JsonviewConfiguration jsonviewConfiguration) {
		this.jsonviewConfiguration = jsonviewConfiguration;
	}

	private ObjectNode constructJson(DataModel dataModel, String namespace, String id) {
		Jsonview jsonview = this.jsonviewConfiguration.extractJsonview(namespace, id);
		ObjectNode root = getObjectMapper().createObjectNode();
		Context context = new Context();
		context.setDataModel(dataModel);
		context.setJsonviewConfiguration(jsonviewConfiguration);
		JsonviewProcessor processor = new JsonviewProcessor(context, jsonview);
		processor.setNode(root);
		processor.process(null);
		return root;
	}

	@Override
	public String createJson(DataModel dataModel, String namespace, String id) {
		return createJson(dataModel, namespace, id, false);
	}

	@Override
	public String createJson(DataModel dataModel, String namespace, String id, boolean isPretty) {
		ObjectNode root = constructJson(dataModel, namespace, id);
		try {
			if (isPretty) {
				return getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(root);
			} else {
				return getObjectMapper().writeValueAsString(root);
			}
		} catch (JsonProcessingException e) {
			e.printStackTrace();
		}
		return null;
	}

	@Override
	public void printJson(JsonGenerator generator, DataModel dataModel, String namespace, String id) {
		ObjectNode root = constructJson(dataModel, namespace, id);
		try {
			getObjectMapper().writeValue(generator, root);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public ObjectMapper getObjectMapper() {
		return jsonviewConfiguration.getObjectMapper();
	}

}
