package com.github.developframework.jsonview.core.element;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.jsonview.core.processor.ArrayProcessor;
import com.github.developframework.jsonview.core.processor.Context;
import com.github.developframework.jsonview.core.processor.Processor;
import com.github.developframework.jsonview.data.Expression;
import lombok.Getter;
import lombok.Setter;

import java.util.Optional;

/**
 * array element
 * 
 * @author qiuzhenhao
 *
 */
public class ArrayElement extends ContainerElement {

	@Getter
	private ObjectElement childObjectElement;

	@Setter
	private String mapFunctionValue;

	public ArrayElement(JsonviewConfiguration configuration, String data, String alias) {
		super(configuration, data, alias);
		this.childObjectElement = new ObjectElement(configuration, data, alias);
	}

	@Override
	public Optional<Processor<? extends Element, ? extends JsonNode>> createProcessor(Context context, ObjectNode parentNode, Expression parentExpression) {
		ArrayProcessor processor = new ArrayProcessor(context, this, parentExpression);
		Optional<Object> optional = context.getDataModel().getData(processor.getExpression());
		if (optional.isPresent()) {
			final ArrayNode arrayNode = parentNode.putArray(this.showName());
			processor.setNode(arrayNode);
			return Optional.of(processor);
		}
		if (!nullHidden) {
			parentNode.putNull(this.showName());
		}
		return Optional.empty();
	}

	@Override
	public void addChildElement(Element element) {
		super.addChildElement(element);
		this.childObjectElement.addChildElement(element);
	}

	public Optional<String> getMapFunctionValueOptional() {
		return Optional.ofNullable(mapFunctionValue);
	}
}
