package com.github.developframework.jsonview.core.element;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.jsonview.core.processor.Context;
import com.github.developframework.jsonview.core.processor.DatePropertyProcessor;
import com.github.developframework.jsonview.core.processor.Processor;
import com.github.developframework.jsonview.data.Expression;
import lombok.Getter;
import lombok.Setter;

import java.util.Optional;

/**
 * property-date
 * 
 * @author qiuzhenhao
 *
 */
public class DatePropertyElement extends PropertyElement {

	@Getter
	@Setter
	private String pattern;

	public DatePropertyElement(JsonviewConfiguration configuration, String data, String alias) {
		super(configuration, data, alias);
	}

	@Override
	public Optional<Processor<? extends Element, ? extends JsonNode>> createProcessor(Context context, ObjectNode parentNode, Expression parentExpression) {
		DatePropertyProcessor processor = new DatePropertyProcessor(context, this, parentExpression, pattern);
		processor.setNode(parentNode);
		return Optional.of(processor);
	}

}
