package com.github.developframework.jsonview.core.element;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.jsonview.core.processor.Context;
import com.github.developframework.jsonview.core.processor.ImportProcessor;
import com.github.developframework.jsonview.core.processor.Processor;
import com.github.developframework.jsonview.data.Expression;
import lombok.Getter;
import lombok.Setter;

import java.util.Optional;

/**
 * import
 * 
 * @author qiuzhenhao
 *
 */
public class ImportElement extends FunctionalElement {

	@Getter
	@Setter
	private String namespace;
	@Getter
	@Setter
	private String id;

	public ImportElement(JsonviewConfiguration configuration, String namespace, String id) {
		super(configuration);
		this.namespace = namespace;
		this.id = id;
	}

	@Override
	public Optional<Processor<? extends Element, ? extends JsonNode>> createProcessor(Context context, ObjectNode parentNode, Expression parentExpression) {
		ImportProcessor processor = new ImportProcessor(context, this, parentExpression);
		processor.setNode(parentNode);
		return Optional.of(processor);
	}
}
