package com.github.developframework.jsonview.core.element;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.github.developframework.jsonview.exception.JsonviewPackageNotFoundException;
import com.github.developframework.jsonview.exception.ResourceNotUniqueException;
import lombok.Getter;
import lombok.Setter;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * jsonview-configuration
 * 
 * @author qiuhenhao
 *
 */
public class JsonviewConfiguration {

	@Setter
	@Getter
	private ObjectMapper objectMapper;
	private Map<String, JsonviewPackage> jsonviewPackages;

	public JsonviewConfiguration() {
		this.jsonviewPackages = new HashMap<>();
	}

	/**
	 * add jsonview-package
	 * 
	 * @param jsonviewPackage jsonviewPackage
	 */
	public void addJsonviewPackage(JsonviewPackage jsonviewPackage) {
		String namespace = jsonviewPackage.getNamespace();
		if (this.jsonviewPackages.containsKey(namespace)) {
			throw new ResourceNotUniqueException(String.format("JsonviewPackage namespace \"%s\" is exist.", namespace));
		}
		this.jsonviewPackages.put(namespace, jsonviewPackage);
	}

	/**
	 * get package
	 * 
	 * @param namespace namespace
	 * @return JsonviewPackage
	 */
	public JsonviewPackage getJsonviewPackageByNamespace(String namespace) {
		JsonviewPackage jsonviewPackage = jsonviewPackages.get(namespace);
		if (Objects.isNull(jsonviewPackage)) {
			throw new JsonviewPackageNotFoundException(namespace);
		}
		return jsonviewPackage;
	}

	/**
	 * extract jsonview
	 * 
	 * @param namespace namespace
	 * @param id jsonviewId
	 * @return jsonview
	 */
	public Jsonview extractJsonview(String namespace, String id) {
		return getJsonviewPackageByNamespace(namespace).getJsonviewById(id);
	}

	public PropertyNamingStrategy getPropertyNamingStrategy() {
		return objectMapper.getPropertyNamingStrategy();
	}
}
