package com.github.developframework.jsonview.core.element;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.jsonview.core.processor.Context;
import com.github.developframework.jsonview.core.processor.ObjectProcessor;
import com.github.developframework.jsonview.core.processor.Processor;
import com.github.developframework.jsonview.data.Expression;

import java.util.Optional;

/**
 * object
 * 
 * @author qiuzhenhao
 *
 */
public class ObjectElement extends ContainerElement {

	public ObjectElement(JsonviewConfiguration configuration) {
		super(configuration, null, null);
	}

	public ObjectElement(JsonviewConfiguration configuration, String data, String alias) {
		super(configuration, data, alias);
	}

	@Override
	public Optional<Processor<? extends Element, ? extends JsonNode>> createProcessor(Context context, ObjectNode parentNode, Expression parentExpression) {
		ObjectProcessor processor = new ObjectProcessor(context, this, parentExpression);
		Optional<Object> optional = context.getDataModel().getData(processor.getExpression());
		if (optional.isPresent()) {
			final ObjectNode objectNode = parentNode.putObject(this.showName());
			processor.setNode(objectNode);
			return Optional.of(processor);
		}
		if (!nullHidden) {
			parentNode.putNull(this.showName());
		}
		return Optional.empty();
	}

}
