package com.github.developframework.jsonview.core.processor;

import com.github.developframework.jsonview.core.element.PropertyElement;
import com.github.developframework.jsonview.data.Expression;
import com.github.developframework.jsonview.exception.LinkObjectSizeNotEqualException;
import lombok.Getter;

import java.util.Collection;
import java.util.List;
import java.util.Optional;

/**
 * A processor for link-property structure
 * 
 * @author qiuzhenhao
 *
 */
public class LinkPropertyProcessor extends NormalPropertyProcessor implements LinkProcessor {

	// array index
	@Getter
	private int index;

	public LinkPropertyProcessor(Context context, PropertyElement element, Expression parentExpression) {
		super(context, element, parentExpression);
	}

	/**
	 * Check whether the number of array elements is the same
	 * 
	 * @param parentArraySize parent array size
	 */
	@Override
	public void checkSize(int parentArraySize) {
		Optional<Object> objOptional = context.getDataModel().getData(expression);
		if (objOptional.isPresent()) {
			int size = 0;
			Object obj = objOptional.get();
			if (obj.getClass().isArray()) {
				size = ((Object[]) obj).length;
			} else if (obj instanceof Collection<?>) {
				size = ((List<?>) obj).size();
			}
			if (size != parentArraySize) {
				throw new LinkObjectSizeNotEqualException(element.getData());
			}
		}
	}

	@Override
	public void setIndex(int index) {
		this.index = index;
		this.expression = Expression.buildArrayExpression(expression, index);
	}
}
