package com.github.developframework.jsonview.core.processor;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.developframework.jsonview.core.element.Element;
import com.github.developframework.jsonview.data.Expression;
import lombok.Getter;
import lombok.Setter;

/**
 * abstract root processor
 * 
 * @author qiuzhenhao
 *
 * @param <ELEMENT> XML element Type
 * @param <NODE> JsonNode
 */
public abstract class Processor<ELEMENT extends Element, NODE extends JsonNode> {

	@Getter
	protected Context context;
	@Getter
	protected ELEMENT element;
	@Getter
	@Setter
	protected NODE node;
	@Getter
	protected Expression expression;

	public Processor(Context context, ELEMENT element, Expression parentExpression) {
		this.context = context;
		this.element = element;
		this.expression = createExpression(parentExpression);
	}

	/**
	 * create expression
	 * 
	 * @param parentExpression parent element expression
	 * @return new expression
	 */
	protected abstract Expression createExpression(Expression parentExpression);

	/**
	 * Deal with the operation of child element
	 * 
	 * @param parentProcessor parent element processor
	 */
	protected abstract void process(DescribeContentProcessor<? extends Element, ? extends JsonNode> parentProcessor);
}
